/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.ListPhotoModel;
import java.util.List;

public class UploadPhotoAdapter
extends BaseListAdapter<Photo> {
    private ListPhotoModel mListPhotoModel;
    private List<Photo> items;

    public UploadPhotoAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View row = this.inflater.inflate(R.layout.upload_photo, parent, false);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        widgets.photo.setImageDrawable(this.getPhoto(((Photo)this.getItem(position)).getPhoto()));
        return row;
    }

    @Override
    public void refresh() {
        this.mListPhotoModel = new ListPhotoModel();
        this.items = this.mListPhotoModel.getPendingPhotos(this.context);
        this.setItems(this.items);
    }

    public void refresh(int reportId) {
        this.mListPhotoModel = new ListPhotoModel();
        this.items = this.mListPhotoModel.getPendingPhotosByReportId(reportId);
        this.setItems(this.items);
    }

    public String pendingPhotos(int reportId) {
        this.mListPhotoModel = new ListPhotoModel();
        this.items = this.mListPhotoModel.getPendingPhotosByReportId(reportId);
        StringBuilder photos = new StringBuilder();
        for (Photo photo : this.items) {
            if (photo.getPhoto().length() <= 0) continue;
            photos.append(photo.getPhoto() + ",");
        }
        if (photos.length() > 0) {
            photos.deleteCharAt(photos.length() - 1);
        }
        return photos.toString();
    }

    public String pendingCheckinPhotos() {
        this.mListPhotoModel = new ListPhotoModel();
        this.items = this.mListPhotoModel.getPendingPhotos(this.context);
        StringBuilder photos = new StringBuilder();
        for (Photo photo : this.items) {
            if (photo.getPhoto().length() <= 0) continue;
            photos.append(photo.getPhoto() + ",");
        }
        if (photos.length() > 0) {
            photos.deleteCharAt(photos.length() - 1);
        }
        return photos.toString();
    }

    private Drawable getPhoto(String fileName) {
        return ImageManager.getDrawables2(this.context, fileName);
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        ImageView photo;

        public Widgets(View view) {
            super(view);
            this.photo = (ImageView)view.findViewById(R.id.upload_photo);
        }
    }
}

