/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseArrayAdapter;
import com.ushahidi.android.app.entities.User;
import com.ushahidi.android.app.models.UserModel;
import java.util.List;

public class UserSpinnerAdater
extends BaseArrayAdapter<User> {
    private static final String DEFAULT_COLOR = "#000000";

    public UserSpinnerAdater(Context context) {
        super(context);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    public View getCustomView(int position, View convertView, ViewGroup parent) {
        Widgets widget;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.users_spinner_row_item, null);
            widget = new Widgets();
            widget.title = (TextView)convertView.findViewById(R.id.username);
            widget.color = (TextView)convertView.findViewById(R.id.user_color);
            convertView.setTag((Object)widget);
        } else {
            widget = (Widgets)convertView.getTag();
        }
        if (((User)this.getTag(position)).getUsername() != null) {
            if (TextUtils.isEmpty((CharSequence)((User)this.getTag(position)).getUsername())) {
                widget.title.setText((CharSequence)this.context.getString(R.string.unknown));
            } else {
                widget.title.setText((CharSequence)((User)this.getTag(position)).getUsername());
            }
        }
        if (((User)this.getTag(position)).getColor() != null) {
            if (TextUtils.isEmpty((CharSequence)((User)this.getTag(position)).getColor().trim())) {
                try {
                    widget.color.setBackgroundColor(Color.parseColor((String)DEFAULT_COLOR));
                }
                catch (IllegalArgumentException exception) {
                    this.log("Error parsing color hex", exception);
                }
            } else {
                try {
                    widget.color.setBackgroundColor(Color.parseColor((String)((User)this.getTag(position)).getColor().trim()));
                }
                catch (IllegalArgumentException exception) {
                    this.log("Error parsing color", exception);
                }
            }
        }
        return convertView;
    }

    @Override
    public void refresh() {
        List<User> listUsers;
        UserModel mUserModel = new UserModel();
        if (mUserModel.load() && (listUsers = mUserModel.users) != null && listUsers.size() > 0) {
            User sUser = new User();
            sUser.setUserId(0);
            sUser.setDbId(0);
            sUser.setUsername(this.context.getString(R.string.all_users));
            sUser.setColor(DEFAULT_COLOR);
            this.add(sUser.getUsername(), sUser);
            for (User user : listUsers) {
                this.add(user.getUsername(), user);
            }
        }
    }

    class Widgets {
        TextView title;
        TextView color;

        Widgets() {
        }
    }
}

