/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.ICategoryDao;
import com.ushahidi.android.app.database.ICategorySchema;
import com.ushahidi.android.app.entities.Category;
import java.util.ArrayList;
import java.util.List;

public class CategoryDao
extends DbContentProvider
implements ICategoryDao,
ICategorySchema {
    private Cursor cursor;
    private List<Category> listCategory;
    private ContentValues initialValues;
    private static final String SORT_ORDER = "position ASC";
    private static final String GROUP_BY = null;

    public CategoryDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<Category> fetchAllCategories() {
        this.cursor = super.query("categories", COLUMNS, null, null, GROUP_BY, null, SORT_ORDER, null);
        this.listCategory = new ArrayList<Category>();
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Category category = this.cursorToEntity(this.cursor);
                this.listCategory.add(category);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCategory;
    }

    @Override
    public List<Category> fetchAllCategoryTitles() {
        String[] columns = new String[]{"_id", "category_id", "category_title", "category_color", "position", "parent_id"};
        String selection = "parent_id = ?";
        this.listCategory = new ArrayList<Category>();
        this.cursor = super.query("categories", columns, "parent_id = ?", new String[]{String.valueOf(0)}, GROUP_BY, null, SORT_ORDER, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Category category = this.cursorToEntity(this.cursor);
                this.listCategory.add(category);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCategory;
    }

    public List<Category> fetchChildrenCategories(int parentId) {
        String[] columns = new String[]{"_id", "category_id", "category_title", "category_color", "position", "parent_id"};
        String selection = "parent_id = ?";
        this.listCategory = new ArrayList<Category>();
        this.cursor = super.query("categories", columns, "parent_id = ?", new String[]{String.valueOf(parentId)}, GROUP_BY, null, SORT_ORDER, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Category category = this.cursorToEntity(this.cursor);
                this.listCategory.add(category);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCategory;
    }

    @Override
    public List<Category> fetchCategoryByReportId(int reportId) {
        String sql = "SELECT * FROM categories category INNER JOIN report_category categories ON category.category_id = categories.category_id AND categories.report_id =?  ORDER BY  category.category_id ASC";
        this.listCategory = new ArrayList<Category>();
        this.cursor = super.rawQuery("SELECT * FROM categories category INNER JOIN report_category categories ON category.category_id = categories.category_id AND categories.report_id =?  ORDER BY  category.category_id ASC", new String[]{String.valueOf(reportId)});
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Category category = this.cursorToEntity(this.cursor);
                this.listCategory.add(category);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCategory;
    }

    @Override
    public boolean deleteAllCategories() {
        return super.delete("categories", null, null) > 0;
    }

    @Override
    public boolean deleteCategory(int id2) {
        String[] selectionArgs = new String[]{String.valueOf(id2)};
        String selection = "_id = ?";
        return super.delete("categories", "_id = ?", selectionArgs) > 0;
    }

    @Override
    public boolean addCategory(Category category) {
        this.setContentValue(category);
        return super.insert("categories", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCategories(List<Category> categories) {
        try {
            this.mDb.beginTransaction();
            for (Category category : categories) {
                this.addCategory(category);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    protected Category cursorToEntity(Cursor cursor) {
        Category category = new Category();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                category.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("category_id") != -1) {
                int categoryIdIndex = cursor.getColumnIndexOrThrow("category_id");
                category.setCategoryId(cursor.getInt(categoryIdIndex));
            }
            if (cursor.getColumnIndex("parent_id") != -1) {
                int parentIdIndex = cursor.getColumnIndexOrThrow("parent_id");
                category.setParentId(cursor.getInt(parentIdIndex));
            }
            if (cursor.getColumnIndex("category_title") != -1) {
                int titleIndex = cursor.getColumnIndexOrThrow("category_title");
                category.setCategoryTitle(cursor.getString(titleIndex));
            }
            if (cursor.getColumnIndex("category_color") != -1) {
                int colorIndex = cursor.getColumnIndexOrThrow("category_color");
                category.setCategoryColor(cursor.getString(colorIndex));
            }
            if (cursor.getColumnIndex("position") != -1) {
                int positionIndex = cursor.getColumnIndexOrThrow("position");
                category.setCategoryPosition(Integer.valueOf(cursor.getString(positionIndex)));
            }
            if (cursor.getColumnIndex("category_desc") != -1) {
                int descriptionIndex = cursor.getColumnIndexOrThrow("category_desc");
                category.setCategoryDescription(cursor.getString(descriptionIndex));
            }
        }
        return category;
    }

    private void setContentValue(Category category) {
        this.initialValues = new ContentValues();
        this.initialValues.put("category_id", Integer.valueOf(category.getCategoryId()));
        this.initialValues.put("parent_id", Integer.valueOf(category.getParentId()));
        this.initialValues.put("category_title", category.getCategoryTitle());
        this.initialValues.put("category_desc", category.getCategoryDescription());
        this.initialValues.put("category_color", category.getCategoryColor());
        this.initialValues.put("position", Integer.valueOf(category.getCategoryPosition()));
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }
}

