/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.ICheckinDao;
import com.ushahidi.android.app.database.ICheckinSchema;
import com.ushahidi.android.app.entities.Checkin;
import java.util.ArrayList;
import java.util.List;

public class CheckinDao
extends DbContentProvider
implements ICheckinDao,
ICheckinSchema {
    private Cursor cursor;
    private List<Checkin> listCheckin;
    private ContentValues initialValues;

    public CheckinDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<Checkin> fetchAllCheckins() {
        this.listCheckin = new ArrayList<Checkin>();
        String sortOrder = "checkin_date DESC";
        this.cursor = super.query("checkins", CHECKINS_COLUMNS, null, null, "checkin_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Checkin checkin = this.cursorToEntity(this.cursor);
                this.listCheckin.add(checkin);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCheckin;
    }

    @Override
    public List<Checkin> fetchAllPendingCheckins() {
        this.listCheckin = new ArrayList<Checkin>();
        String sortOrder = "checkin_date DESC";
        String selection = "pending = ?";
        String[] selectionArgs = new String[]{String.valueOf(1)};
        this.cursor = super.query("checkins", CHECKINS_COLUMNS, "pending = ?", selectionArgs, "checkin_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Checkin checkin = this.cursorToEntity(this.cursor);
                this.listCheckin.add(checkin);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCheckin;
    }

    @Override
    public Checkin fetchPendingCheckinById(int checkinId) {
        this.listCheckin = new ArrayList<Checkin>();
        String sortOrder = "checkin_date DESC";
        String selection = "pending = ? AND _id =?";
        String[] selectionArgs = new String[]{String.valueOf(1), String.valueOf(checkinId)};
        Checkin checkin = new Checkin();
        this.cursor = super.query("checkins", CHECKINS_COLUMNS, "pending = ? AND _id =?", selectionArgs, "checkin_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                checkin = this.cursorToEntity(this.cursor);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return checkin;
    }

    protected Checkin cursorToEntity(Cursor cursor) {
        Checkin checkin = new Checkin();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                checkin.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("checkin_id") != -1) {
                int checkinIdIndex = cursor.getColumnIndexOrThrow("checkin_id");
                checkin.setCheckinId(cursor.getInt(checkinIdIndex));
            }
            if (cursor.getColumnIndex("user_id") != -1) {
                int userIdIndex = cursor.getColumnIndexOrThrow("user_id");
                checkin.setUserId(cursor.getInt(userIdIndex));
            }
            if (cursor.getColumnIndex("checkin_date") != -1) {
                int dateIndex = cursor.getColumnIndexOrThrow("checkin_date");
                checkin.setDate(cursor.getString(dateIndex));
            }
            if (cursor.getColumnIndex("checkin_mesg") != -1) {
                int messageIndex = cursor.getColumnIndexOrThrow("checkin_mesg");
                checkin.setMessage(cursor.getString(messageIndex));
            }
            if (cursor.getColumnIndex("checki_loc_name") != -1) {
                int locationIndex = cursor.getColumnIndexOrThrow("checki_loc_name");
                checkin.setLocationName(cursor.getString(locationIndex));
            }
            if (cursor.getColumnIndex("checkin_loc_latitude") != -1) {
                int latitudeIndex = cursor.getColumnIndexOrThrow("checkin_loc_latitude");
                checkin.setLocationLatitude(cursor.getString(latitudeIndex));
            }
            if (cursor.getColumnIndex("checkin_loc_longitude") != -1) {
                int longitudeIndex = cursor.getColumnIndexOrThrow("checkin_loc_longitude");
                checkin.setLocationLongitude(cursor.getString(longitudeIndex));
            }
        }
        return checkin;
    }

    @Override
    public List<Checkin> fetchCheckinsByUserId(int userId) {
        this.listCheckin = new ArrayList<Checkin>();
        String sortOrder = "checkin_date DESC";
        String[] selectionArgs = new String[]{String.valueOf(userId), String.valueOf(0)};
        String selection = "user_id = ? AND pending =? ";
        this.cursor = super.query("checkins", CHECKINS_COLUMNS, "user_id = ? AND pending =? ", selectionArgs, "checkin_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Checkin checkin = this.cursorToEntity(this.cursor);
                this.listCheckin.add(checkin);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCheckin;
    }

    @Override
    public boolean deleteAllCheckins() {
        return super.delete("checkins", null, null) > 0;
    }

    @Override
    public boolean addCheckin(Checkin checkin) {
        this.setContentValue(checkin);
        return super.insert("checkins", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCheckins(List<Checkin> checkins) {
        try {
            this.mDb.beginTransaction();
            for (Checkin checkin : checkins) {
                this.addCheckin(checkin);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    private void setContentValue(Checkin checkins) {
        this.initialValues = new ContentValues();
        this.initialValues.put("checkin_id", Integer.valueOf(checkins.getCheckinId()));
        this.initialValues.put("user_id", Integer.valueOf(checkins.getUserId()));
        this.initialValues.put("checkin_mesg", checkins.getMessage());
        this.initialValues.put("checkin_date", checkins.getDate());
        this.initialValues.put("checki_loc_name", checkins.getLocationName());
        this.initialValues.put("checkin_loc_latitude", checkins.getLocationLatitude());
        this.initialValues.put("checkin_loc_longitude", checkins.getLocationLongitude());
        this.initialValues.put("pending", Integer.valueOf(checkins.getPending()));
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    @Override
    public List<Checkin> fetchPendingCheckinsByUserId(int userId) {
        this.listCheckin = new ArrayList<Checkin>();
        String sortOrder = "checkin_date DESC";
        String[] selectionArgs = new String[]{String.valueOf(userId), String.valueOf(1)};
        String selection = "user_id = ? AND pending =? ";
        this.cursor = super.query("checkins", CHECKINS_COLUMNS, "user_id = ? AND pending =? ", selectionArgs, "checkin_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Checkin checkin = this.cursorToEntity(this.cursor);
                this.listCheckin.add(checkin);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listCheckin;
    }

    @Override
    public boolean deletePendingCheckinById(int checkinId) {
        String[] selectionArgs = new String[]{String.valueOf(checkinId), String.valueOf(1)};
        String selection = "_id = ? AND pending = ?";
        return super.delete("checkins", "_id = ? AND pending = ?", selectionArgs) > 0;
    }

    @Override
    public boolean deleteCheckinById(int checkinId) {
        String[] selectionArgs = new String[]{String.valueOf(checkinId), String.valueOf(0)};
        String selection = "_id = ? AND pending = ?";
        return super.delete("checkins", "_id = ? AND pending = ?", selectionArgs) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePendingCheckin(int checkinId, Checkin checkin) {
        boolean status = false;
        try {
            this.mDb.beginTransaction();
            String[] selectionArgs = new String[]{String.valueOf(checkinId), String.valueOf(1)};
            String selection = "_id = ? AND pending = ?";
            this.setContentValue(checkin);
            super.update("checkins", this.getContentValue(), "_id = ? AND pending = ?", selectionArgs);
            this.mDb.setTransactionSuccessful();
            status = true;
        }
        finally {
            this.mDb.endTransaction();
        }
        return status;
    }

    @Override
    public int fetchPendingCheckinIdByDate(String date) {
        String sortOrder = "_id DESC";
        String[] selectionArgs = new String[]{date, String.valueOf(1)};
        String selection = "checkin_date =? AND pending =? ";
        int id2 = 0;
        this.listCheckin = new ArrayList<Checkin>();
        this.cursor = super.query("checkins", null, "checkin_date =? AND pending =? ", selectionArgs, "_id DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Checkin checkin = this.cursorToEntity(this.cursor);
                id2 = checkin.getDbId();
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return id2;
    }
}

