/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.ICommentDao;
import com.ushahidi.android.app.database.ICommentSchema;
import com.ushahidi.android.app.entities.Comment;
import java.util.ArrayList;
import java.util.List;

public class CommentDao
extends DbContentProvider
implements ICommentDao,
ICommentSchema {
    private Cursor cursor;
    private List<Comment> listComment;
    private ContentValues initialValues;

    public CommentDao(SQLiteDatabase db) {
        super(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addComment(List<Comment> comments) {
        try {
            this.mDb.beginTransaction();
            for (Comment comment : comments) {
                this.addComment(comment);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    @Override
    public boolean addComment(Comment comment) {
        this.setContentValue(comment);
        return super.insert("comment", this.getContentValue()) > 0L;
    }

    @Override
    public List<Comment> fetchCheckinComment(int checkinId) {
        this.listComment = new ArrayList<Comment>();
        String sortOrder = "comment_date DESC";
        String selection = "checkin_id = " + checkinId;
        this.cursor = super.query("comment", COMMENT_COLUMN, selection, null, "comment_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Comment comment = this.cursorToEntity(this.cursor);
                this.listComment.add(comment);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listComment;
    }

    @Override
    public List<Comment> fetchReportComment(int reportId) {
        this.listComment = new ArrayList<Comment>();
        String sortOrder = "comment_date DESC";
        String selection = "report_id = " + reportId;
        this.cursor = super.query("comment", COMMENT_COLUMN, selection, null, "comment_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Comment comment = this.cursorToEntity(this.cursor);
                this.listComment.add(comment);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listComment;
    }

    @Override
    public boolean updateCheckinByReportId(int reportId) {
        return false;
    }

    @Override
    public boolean updateCheckinByCheckinId(int checkinId) {
        return false;
    }

    @Override
    public boolean deleteAllComment() {
        return super.delete("comment", null, null) > 0;
    }

    @Override
    public boolean deleteCommentByReportId(int reportId) {
        String[] selectionArgs = new String[]{String.valueOf(reportId)};
        String selection = "report_id =? ";
        return super.delete("comment", "report_id =? ", selectionArgs) > 0;
    }

    @Override
    public boolean deleteCommentByCheckinId(int checkinId) {
        String[] selectionArgs = new String[]{String.valueOf(checkinId)};
        String selection = "checkin_id =? ";
        return super.delete("comment", "checkin_id =? ", selectionArgs) > 0;
    }

    private void setContentValue(Comment comment) {
        this.initialValues = new ContentValues();
        this.initialValues.put("comment_id", Integer.valueOf(comment.getCommentId()));
        this.initialValues.put("report_id", Integer.valueOf(comment.getReportId()));
        this.initialValues.put("checkin_id", Integer.valueOf(comment.getCheckinId()));
        this.initialValues.put("comment_author", comment.getCommentAuthor());
        this.initialValues.put("comment_date", comment.getCommentDate());
        this.initialValues.put("comment_description", comment.getCommentDescription());
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    protected Comment cursorToEntity(Cursor cursor) {
        Comment comment = new Comment();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                comment.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("report_id") != -1) {
                int reportIdIndex = cursor.getColumnIndexOrThrow("report_id");
                comment.setReportId(cursor.getInt(reportIdIndex));
            }
            if (cursor.getColumnIndex("checkin_id") != -1) {
                int checkinIdIndex = cursor.getColumnIndexOrThrow("checkin_id");
                comment.setCheckinId(cursor.getInt(checkinIdIndex));
            }
            if (cursor.getColumnIndex("comment_author") != -1) {
                int commentAuthorIndex = cursor.getColumnIndexOrThrow("comment_author");
                comment.setCommentAuthor(cursor.getString(commentAuthorIndex));
            }
            if (cursor.getColumnIndex("comment_description") != -1) {
                int commentDescriptionIndex = cursor.getColumnIndexOrThrow("comment_description");
                comment.setCommentDescription(cursor.getString(commentDescriptionIndex));
            }
            if (cursor.getColumnIndex("comment_date") != -1) {
                int commentDateIndex = cursor.getColumnIndexOrThrow("comment_date");
                comment.setCommentDate(cursor.getString(commentDateIndex));
            }
            if (cursor.getColumnIndex("comment_id") != -1) {
                int commentIdIndex = cursor.getColumnIndexOrThrow("comment_id");
                comment.setCommentId(cursor.getInt(commentIdIndex));
            }
        }
        return comment;
    }
}

