/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.database.CategoryDao;
import com.ushahidi.android.app.database.CheckinDao;
import com.ushahidi.android.app.database.CommentDao;
import com.ushahidi.android.app.database.IMapSchema;
import com.ushahidi.android.app.database.MapDao;
import com.ushahidi.android.app.database.MediaDao;
import com.ushahidi.android.app.database.OfflineReportDao;
import com.ushahidi.android.app.database.OpenGeoSmsDao;
import com.ushahidi.android.app.database.ReportCategoryDao;
import com.ushahidi.android.app.database.ReportDao;
import com.ushahidi.android.app.database.UserDao;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Database {
    private static final String TAG = "UshahidiDatabase";
    private DatabaseHelper mDbHelper;
    private SQLiteDatabase mDb;
    public static final String DATABASE_NAME = "ushahidi_db";
    private static final int DATABASE_VERSION = 17;
    private final Context mContext;
    public static ReportDao mReportDao;
    public static CategoryDao mCategoryDao;
    public static MapDao mMapDao;
    public static ReportCategoryDao mReportCategoryDao;
    public static MediaDao mMediaDao;
    public static OfflineReportDao mOfflineReport;
    public static CheckinDao mCheckin;
    public static UserDao mUserDao;
    public static CommentDao mCommentDao;
    public static OpenGeoSmsDao mOpenGeoSmsDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumns(SQLiteDatabase db, String tableName) {
        ArrayList<String> ar = null;
        try (Cursor c = null;){
            c = db.rawQuery("SELECT * FROM " + tableName + " LIMIT 1", null);
            if (c != null) {
                ar = new ArrayList<String>(Arrays.asList(c.getColumnNames()));
            }
        }
        return ar;
    }

    public static String join(List<String> list, String delim) {
        StringBuilder buf = new StringBuilder();
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }

    public Database(Context context) {
        this.mContext = context;
    }

    public static List<String> getTableColumns(SQLiteDatabase db, String tableName) {
        ArrayList<String> columns = new ArrayList<String>();
        String cmd = "pragma table_info(" + tableName + ");";
        Cursor cur = db.rawQuery(cmd, null);
        while (cur.moveToNext()) {
            columns.add(cur.getString(cur.getColumnIndex("name")));
        }
        cur.close();
        return columns;
    }

    private static void dropColumn(SQLiteDatabase db, String createTableCmd, String tableName, String[] colsToRemove) {
        List<String> updatedTableColumns = Database.getTableColumns(db, tableName);
        updatedTableColumns.removeAll(Arrays.asList(colsToRemove));
        String columnsSeperated = TextUtils.join((CharSequence)",", updatedTableColumns);
        db.execSQL("ALTER TABLE " + tableName + " RENAME TO " + tableName + "_old;");
        db.execSQL(createTableCmd);
        db.execSQL("INSERT INTO " + tableName + "(" + columnsSeperated + ") SELECT " + columnsSeperated + " FROM " + tableName + "_old;");
        db.execSQL("DROP TABLE " + tableName + "_old;");
    }

    public static boolean doesVirtualTableExists(SQLiteDatabase db, String tableName) {
        Cursor cursor = db.rawQuery(String.format("SELECT DISTINCT tbl_name from sqlite_master where tbl_name ='%s'", tableName), null);
        if (cursor.getCount() > 0) {
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }

    public Database open() throws SQLException {
        this.mDbHelper = new DatabaseHelper(this.mContext);
        this.mDb = this.mDbHelper.getWritableDatabase();
        mReportDao = new ReportDao(this.mDb);
        mCategoryDao = new CategoryDao(this.mDb);
        mMapDao = new MapDao(this.mDb);
        mMediaDao = new MediaDao(this.mDb);
        mReportCategoryDao = new ReportCategoryDao(this.mDb);
        mOfflineReport = new OfflineReportDao(this.mDb);
        mCheckin = new CheckinDao(this.mDb);
        mUserDao = new UserDao(this.mDb);
        mCommentDao = new CommentDao(this.mDb);
        mOpenGeoSmsDao = new OpenGeoSmsDao(this.mDb);
        return this;
    }

    public void close() {
        this.mDbHelper.close();
    }

    public boolean clearData() {
        Util.rmDir(Preferences.savePath);
        return true;
    }

    public boolean clearReports() {
        this.deleteAllCategories();
        this.deleteCheckinMedia();
        Util.rmDir(Preferences.savePath);
        return true;
    }

    public boolean deleteAllCategories() {
        Log.i((String)TAG, (String)"Deleting all categories");
        return true;
    }

    public boolean deleteCategory(int id2) {
        Log.i((String)TAG, (String)("Deleteing all Category by id " + id2));
        return true;
    }

    public boolean deleteCheckinMedia() {
        Log.i((String)TAG, (String)"Deleting all Media Checkins");
        return this.mDb.delete("checkin_media", null, null) > 0;
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, Database.DATABASE_NAME, null, 17);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE IF NOT EXISTS incidents (_id INTEGER PRIMARY KEY AUTOINCREMENT,incident_id INTEGER , incident_title TEXT NOT NULL, incident_desc TEXT, incident_date DATE NOT NULL, incident_mode INTEGER, incident_verified INTEGER, incident_loc_name TEXT NOT NULL, incident_loc_latitude TEXT NOT NULL, incident_loc_longitude TEXT NOT NULL, pending INTEGER DEFAULT 0 )");
            db.execSQL("CREATE TABLE IF NOT EXISTS categories (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER , parent_id INTEGER , category_title TEXT NOT NULL, category_desc TEXT, category_color TEXT, position INTEGER )");
            if (!Database.doesVirtualTableExists(db, "deployment")) {
                db.execSQL("CREATE VIRTUAL TABLE deployment USING fts3 (_id  INTEGER PRIMARY KEY AUTOINCREMENT, map_id INTEGER, cat_id INTEGER, deployment_active INTEGER, name TEXT NOT NULL, discovery_date DATE NOT NULL, desc TEXT NOT NULL, url TEXT NOT NULL, latitude TEXT NOT NULL, longitude TEXT NOT NULL)");
            }
            db.execSQL(IMapSchema.DEFAULT_MAP_CREATE);
            db.execSQL("CREATE TABLE IF NOT EXISTS report_category (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER NOT NULL, report_id INTEGER NOT NULL )");
            db.execSQL("CREATE TABLE IF NOT EXISTS checkin_media (_id INTEGER PRIMARY KEY AUTOINCREMENT, media_id INTEGER , media_checkin_id INTEGER, media_report_id INTEGER, media_type INTEGER, media_link TEXT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS users (_id INTEGER PRIMARY KEY AUTOINCREMENT, user_id INTEGER , user_name TEXT NOT NULL, user_color TEXT)");
            db.execSQL("CREATE TABLE IF NOT EXISTS checkins (_id INTEGER PRIMARY KEY AUTOINCREMENT, checkin_id INTEGER , user_id INTEGER, checkin_mesg TEXT NOT NULL, checkin_date DATE NOT NULL, checki_loc_name TEXT NOT NULL, checkin_loc_latitude TEXT NOT NULL, checkin_loc_longitude TEXT NOT NULL, pending INTEGER DEFAULT 0 )");
            db.execSQL("CREATE TABLE IF NOT EXISTS offline_report (_id INTEGER PRIMARY KEY , incident_title TEXT NOT NULL, incident_desc TEXT, incident_date DATE NOT NULL, incident_hour INTEGER, incident_minute INTEGER, incident_ampm TEXT NOT NULL, incident_categories TEXT NOT NULL, incident_loc_name TEXT NOT NULL, incident_loc_latitude TEXT NOT NULL, incident_loc_longitude TEXT NOT NULL, incident_photo TEXT, incident_video TEXT, incident_news TEXT, person_first TEXT, person_last TEXT, person_email TEXT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS comment (_id INTEGER PRIMARY KEY AUTOINCREMENT, comment_id INTEGER , checkin_id INTEGER, report_id INTEGER, comment_date DATE NOT NULL, comment_author TEXT, comment_description TEXT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS opengeosms(_id INTEGER PRIMARY KEY AUTOINCREMENT,report_id INTEGER NOT NULL, state INTEGER NOT NULL)");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w((String)Database.TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + " which destroys all old data"));
            try {
                Log.i((String)"Upgrading", (String)"Upgrading incidents table");
                Database.dropColumn(db, "CREATE TABLE IF NOT EXISTS incidents (_id INTEGER PRIMARY KEY AUTOINCREMENT,incident_id INTEGER , incident_title TEXT NOT NULL, incident_desc TEXT, incident_date DATE NOT NULL, incident_mode INTEGER, incident_verified INTEGER, incident_loc_name TEXT NOT NULL, incident_loc_latitude TEXT NOT NULL, incident_loc_longitude TEXT NOT NULL, pending INTEGER DEFAULT 0 )", "incidents", new String[]{"incident_categories", "incident_media", "incident_image", "is_unread"});
                Log.i((String)"Upgrading", (String)"Upgrading categories table");
                Database.dropColumn(db, "CREATE TABLE IF NOT EXISTS categories (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER , parent_id INTEGER , category_title TEXT NOT NULL, category_desc TEXT, category_color TEXT, position INTEGER )", "categories", new String[]{"is_unread"});
                Log.i((String)"Upgrading", (String)"Upgrading offline incidents table");
                db.execSQL("DROP TABLE IF EXISTS offline_report");
                db.execSQL("CREATE TABLE IF NOT EXISTS offline_report (_id INTEGER PRIMARY KEY , incident_title TEXT NOT NULL, incident_desc TEXT, incident_date DATE NOT NULL, incident_hour INTEGER, incident_minute INTEGER, incident_ampm TEXT NOT NULL, incident_categories TEXT NOT NULL, incident_loc_name TEXT NOT NULL, incident_loc_latitude TEXT NOT NULL, incident_loc_longitude TEXT NOT NULL, incident_photo TEXT, incident_video TEXT, incident_news TEXT, person_first TEXT, person_last TEXT, person_email TEXT )");
                List<String> addIncidentColumns = Database.getColumns(db, "offline_report");
                db.execSQL("ALTER TABLE offline_report RENAME TO temp_offline_report");
                db.execSQL("CREATE TABLE IF NOT EXISTS offline_report (_id INTEGER PRIMARY KEY , incident_title TEXT NOT NULL, incident_desc TEXT, incident_date DATE NOT NULL, incident_hour INTEGER, incident_minute INTEGER, incident_ampm TEXT NOT NULL, incident_categories TEXT NOT NULL, incident_loc_name TEXT NOT NULL, incident_loc_latitude TEXT NOT NULL, incident_loc_longitude TEXT NOT NULL, incident_photo TEXT, incident_video TEXT, incident_news TEXT, person_first TEXT, person_last TEXT, person_email TEXT )");
                addIncidentColumns.retainAll(Database.getColumns(db, "offline_report"));
                String addIncidentCols = Database.join(addIncidentColumns, ",");
                db.execSQL(String.format("INSERT INTO %s (%s) SELECT %s FROM temp_%s", "offline_report", addIncidentCols, addIncidentCols, "offline_report"));
                db.execSQL("DROP TABLE IF EXISTS temp_offline_report");
                Log.i((String)"Upgrading", (String)"Upgrading checkins table");
                db.execSQL("CREATE TABLE IF NOT EXISTS checkins (_id INTEGER PRIMARY KEY AUTOINCREMENT, checkin_id INTEGER , user_id INTEGER, checkin_mesg TEXT NOT NULL, checkin_date DATE NOT NULL, checki_loc_name TEXT NOT NULL, checkin_loc_latitude TEXT NOT NULL, checkin_loc_longitude TEXT NOT NULL, pending INTEGER DEFAULT 0 )");
                List<String> checkinsColums = Database.getColumns(db, "checkins");
                db.execSQL("ALTER TABLE checkins RENAME TO temp_checkins");
                db.execSQL("CREATE TABLE IF NOT EXISTS checkins (_id INTEGER PRIMARY KEY AUTOINCREMENT, checkin_id INTEGER , user_id INTEGER, checkin_mesg TEXT NOT NULL, checkin_date DATE NOT NULL, checki_loc_name TEXT NOT NULL, checkin_loc_latitude TEXT NOT NULL, checkin_loc_longitude TEXT NOT NULL, pending INTEGER DEFAULT 0 )");
                checkinsColums.retainAll(Database.getColumns(db, "checkins"));
                String checkinsCols = Database.join(checkinsColums, ",");
                db.execSQL(String.format("INSERT INTO %s (%s) SELECT %s FROM temp_%s", "checkins", checkinsCols, checkinsCols, "checkins"));
                db.execSQL("DROP TABLE IF EXISTS temp_checkins");
                Log.i((String)"Upgrading", (String)"Upgrading checkin media table");
                Database.dropColumn(db, "CREATE TABLE IF NOT EXISTS checkin_media (_id INTEGER PRIMARY KEY AUTOINCREMENT, media_id INTEGER , media_checkin_id INTEGER, media_report_id INTEGER, media_type INTEGER, media_link TEXT )", "checkin_media", new String[]{"media_thumbnail_link", "media_medium_link"});
                Log.i((String)"Upgrading", (String)"Upgrading checkin users table");
                db.execSQL("CREATE TABLE IF NOT EXISTS users (_id INTEGER PRIMARY KEY AUTOINCREMENT, user_id INTEGER , user_name TEXT NOT NULL, user_color TEXT)");
                List<String> usersColumns = Database.getColumns(db, "users");
                db.execSQL("ALTER TABLE users RENAME TO temp_users");
                db.execSQL("CREATE TABLE IF NOT EXISTS users (_id INTEGER PRIMARY KEY AUTOINCREMENT, user_id INTEGER , user_name TEXT NOT NULL, user_color TEXT)");
                usersColumns.retainAll(Database.getColumns(db, "users"));
                String usersCols = Database.join(usersColumns, ",");
                db.execSQL(String.format("INSERT INTO %s (%s) SELECT %s FROM temp_%s", "users", usersCols, usersCols, "users"));
                db.execSQL("DROP TABLE IF EXISTS temp_users");
                db.execSQL("CREATE TABLE IF NOT EXISTS categories (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER , parent_id INTEGER , category_title TEXT NOT NULL, category_desc TEXT, category_color TEXT, position INTEGER )");
                List<String> categoriesColumns = Database.getColumns(db, "categories");
                db.execSQL("ALTER TABLE categories RENAME TO temp_categories");
                db.execSQL("CREATE TABLE IF NOT EXISTS categories (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER , parent_id INTEGER , category_title TEXT NOT NULL, category_desc TEXT, category_color TEXT, position INTEGER )");
                usersColumns.retainAll(Database.getColumns(db, "categories"));
                String categoriesCols = Database.join(categoriesColumns, ",");
                db.execSQL(String.format("INSERT INTO %s (%s) SELECT %s FROM temp_%s", "categories", categoriesCols, categoriesCols, "categories"));
                db.execSQL("DROP TABLE IF EXISTS temp_categories");
                List<String> deploymentColumns = Database.getColumns(db, "deployment");
                db.execSQL("ALTER TABLE deployment RENAME TO temp_deployment");
                db.execSQL("DROP TABLE IF EXISTS deployment");
                db.execSQL("CREATE VIRTUAL TABLE deployment USING fts3 (_id  INTEGER PRIMARY KEY AUTOINCREMENT, map_id INTEGER, cat_id INTEGER, deployment_active INTEGER, name TEXT NOT NULL, discovery_date DATE NOT NULL, desc TEXT NOT NULL, url TEXT NOT NULL, latitude TEXT NOT NULL, longitude TEXT NOT NULL)");
                deploymentColumns.retainAll(Database.getColumns(db, "deployment"));
                String deploymentCols = Database.join(deploymentColumns, ",");
                db.execSQL(String.format("INSERT INTO %s (%s) SELECT %s FROM temp_%s", "deployment", deploymentCols, deploymentCols, "deployment"));
                db.execSQL("DROP TABLE IF EXISTS temp_deployment");
                db.execSQL("CREATE TABLE IF NOT EXISTS report_category (_id INTEGER PRIMARY KEY AUTOINCREMENT, category_id INTEGER NOT NULL, report_id INTEGER NOT NULL )");
                db.execSQL("CREATE TABLE IF NOT EXISTS comment (_id INTEGER PRIMARY KEY AUTOINCREMENT, comment_id INTEGER , checkin_id INTEGER, report_id INTEGER, comment_date DATE NOT NULL, comment_author TEXT, comment_description TEXT )");
                this.onCreate(db);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

