/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.ushahidi.android.app.MainApplication;
import com.ushahidi.android.app.util.DbUtils;

public abstract class DbSqliteHelper
extends SQLiteOpenHelper {
    public DbSqliteHelper(Context context, String name, int version) {
        super(context, name, null, version);
    }

    protected abstract String getTableName();

    public void onCreate(SQLiteDatabase db) {
        this.log("Creating database table for " + this.getTableName());
        String createStatement = DbUtils.getCreateTable(this.getTableName());
        try {
            db.execSQL(createStatement);
        }
        catch (SQLiteException ex) {
            if (ex.getMessage().startsWith("table " + this.getTableName() + " already exists: ")) {
                this.log("Table already exists: " + this.getTableName());
            }
            this.log("Error executing SQL: " + createStatement, (Exception)((Object)ex));
            throw ex;
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.log("Database version changed from " + oldVersion + " to " + newVersion);
        db.execSQL("DROP TABLE IF EXISTS " + this.getTableName());
        this.onCreate(db);
    }

    protected void log(String message) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)message);
        }
    }

    protected void log(String format, Object ... args) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)String.format(format, args));
        }
    }

    protected void log(String message, Exception ex) {
        if (MainApplication.LOGGING_MODE) {
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)message, (Throwable)ex);
        }
    }
}

