/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IMapDao;
import com.ushahidi.android.app.database.IMapSchema;
import com.ushahidi.android.app.entities.Map;
import java.util.ArrayList;
import java.util.List;

public class MapDao
extends DbContentProvider
implements IMapDao,
IMapSchema {
    private ContentValues initialValues;
    private Cursor cursor;
    private List<Map> listMap;

    public MapDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<Map> fetchMapById(int id2) {
        String selection = "rowid =" + id2;
        String[] columns = new String[]{"rowid", "map_id", "name", "desc", "latitude", "longitude", "url"};
        String sortOrder = "discovery_date DESC";
        this.listMap = new ArrayList<Map>();
        this.cursor = super.query("deployment", columns, selection, null, "discovery_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Map map = this.cursorToEntity(this.cursor);
                this.listMap.add(map);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMap;
    }

    @Override
    public void setActiveDeployment(int id2) {
        String sql = "UPDATE deployment SET deployment_active= ? WHERE rowid= ?";
        super.rawQuery(sql, new String[]{"1", String.valueOf(id2)});
    }

    @Override
    public boolean deleteMapById(int id2) {
        String selection = " rowid =" + id2;
        return super.delete("deployment", selection, null) > 0;
    }

    @Override
    public boolean deleteAllMap() {
        return super.delete("deployment", null, null) > 0;
    }

    @Override
    public boolean deleteAllAutoMap() {
        String whereClause = "_id  <> 0";
        return super.delete("deployment", whereClause, null) > 0;
    }

    @Override
    public boolean updateMap(Map map) {
        this.initialValues = new ContentValues();
        this.initialValues.put("desc", map.getDesc());
        this.initialValues.put("name", map.getName());
        this.initialValues.put("url", map.getUrl());
        String whereClause = "rowid = " + map.getDbId();
        return super.update("deployment", this.initialValues, whereClause, null) > 0;
    }

    @Override
    public boolean addMap(Map map) {
        this.setContentValue(map);
        return super.insert("deployment", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMaps(List<Map> maps) {
        try {
            this.mDb.beginTransaction();
            for (Map map : maps) {
                this.addMap(map);
            }
            this.mDb.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        finally {
            this.mDb.endTransaction();
        }
    }

    @Override
    public List<Map> fetchAllMaps() {
        String sortOrder = "discovery_date DESC";
        String[] columns = new String[]{"rowid", "map_id", "name", "url", "desc", "cat_id", "deployment_active", "latitude", "longitude", "discovery_date"};
        this.listMap = new ArrayList<Map>();
        this.cursor = super.query("deployment", columns, null, null, "discovery_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Map map = this.cursorToEntity(this.cursor);
                this.listMap.add(map);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMap;
    }

    @Override
    public List<Map> fetchMapByIdAndUrl(int id2, int mapId) {
        String selection = " rowid =" + DatabaseUtils.sqlEscapeString((String)String.valueOf(id2)) + " AND " + "map_id" + "=" + mapId;
        String[] columns = new String[]{"rowid", "name", "desc", "latitude", "longitude", "url"};
        String sortOrder = "discovery_date DESC";
        this.listMap = new ArrayList<Map>();
        this.cursor = super.query("deployment", columns, selection, null, "discovery_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Map map = this.cursorToEntity(this.cursor);
                this.listMap.add(map);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMap;
    }

    @Override
    public List<Map> fetchMap(Cursor cursor) {
        this.listMap = new ArrayList<Map>();
        if (cursor != null) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Map map = this.cursorToEntity(cursor);
                this.listMap.add(map);
                cursor.moveToNext();
            }
            cursor.close();
        }
        return this.listMap;
    }

    private void setContentValue(Map map) {
        this.initialValues = new ContentValues();
        this.initialValues.put("map_id", Integer.valueOf(map.getMapId()));
        this.initialValues.put("cat_id", Integer.valueOf(map.getCatId()));
        this.initialValues.put("desc", map.getDesc());
        this.initialValues.put("discovery_date", map.getDate());
        this.initialValues.put("name", map.getName());
        this.initialValues.put("deployment_active", map.getActive());
        this.initialValues.put("url", map.getUrl());
        this.initialValues.put("latitude", map.getLat());
        this.initialValues.put("longitude", map.getLon());
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    protected Map cursorToEntity(Cursor cursor) {
        Map map = new Map();
        if (cursor != null) {
            if (cursor.getColumnIndex("rowid") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("rowid");
                map.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("map_id") != -1) {
                int mapIdIndex = cursor.getColumnIndexOrThrow("map_id");
                map.setMapId(cursor.getInt(mapIdIndex));
            }
            if (cursor.getColumnIndex("name") != -1) {
                int nameIndex = cursor.getColumnIndexOrThrow("name");
                map.setName(cursor.getString(nameIndex));
            }
            if (cursor.getColumnIndex("url") != -1) {
                int urlIndex = cursor.getColumnIndexOrThrow("url");
                map.setUrl(cursor.getString(urlIndex));
            }
            if (cursor.getColumnIndex("desc") != -1) {
                int descIndex = cursor.getColumnIndexOrThrow("desc");
                map.setDesc(cursor.getString(descIndex));
            }
            if (cursor.getColumnIndex("cat_id") != -1) {
                int catIdIndex = cursor.getColumnIndexOrThrow("cat_id");
                map.setCatId(cursor.getInt(catIdIndex));
            }
            if (cursor.getColumnIndex("latitude") != -1) {
                int latitudeIndex = cursor.getColumnIndexOrThrow("latitude");
                map.setLat(cursor.getString(latitudeIndex));
            }
            if (cursor.getColumnIndex("longitude") != -1) {
                int longitudeIndex = cursor.getColumnIndexOrThrow("longitude");
                map.setLon(cursor.getString(longitudeIndex));
            }
            if (cursor.getColumnIndex("discovery_date") != -1) {
                int dateIndex = cursor.getColumnIndexOrThrow("discovery_date");
                map.setDate(cursor.getString(dateIndex));
            }
            if (cursor.getColumnIndex("deployment_active") != -1) {
                int activeIndex = cursor.getColumnIndexOrThrow("deployment_active");
                map.setActive(cursor.getString(activeIndex));
            }
        }
        return map;
    }
}

