/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IMediaDao;
import com.ushahidi.android.app.database.IMediaSchema;
import com.ushahidi.android.app.entities.Media;
import java.util.ArrayList;
import java.util.List;

public class MediaDao
extends DbContentProvider
implements IMediaDao,
IMediaSchema {
    private Cursor cursor;
    private List<Media> listMedia;
    private ContentValues initialValues;

    public MediaDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<Media> fetchCheckinPhoto(int checkinId) {
        this.listMedia = new ArrayList<Media>();
        String[] selectionArgs = new String[]{String.valueOf(checkinId), String.valueOf(1)};
        String selection = "media_checkin_id =? AND media_type =?";
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, "media_checkin_id =? AND media_type =?", selectionArgs, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchReportPhoto(int reportId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_report_id = " + reportId + " AND " + "media_type" + " =" + 1;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchPendingCheckinPhoto(int checkinId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_checkin_id = " + checkinId + " AND " + "media_type" + " =" + 1;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchPendingReportPhoto(int reportId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_report_id = " + reportId + " AND " + "media_type" + " =" + 1;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchReportVideo(int reportId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_report_id = " + reportId + " AND " + "media_type" + " =" + 2;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchReportAudio(int reportId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_report_id = " + reportId + " AND " + "media_type" + " =" + 3;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchReportNews(int reportId) {
        this.listMedia = new ArrayList<Media>();
        String selection = "media_report_id = " + reportId + " AND " + "media_type" + " =" + 4;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public List<Media> fetchMedia(String itemType, int itemId, int mediaType, int limit) {
        this.listMedia = new ArrayList<Media>();
        String selection = itemType + " =" + itemId + " AND " + "media_type" + " =" + mediaType;
        this.cursor = super.query("checkin_media", MEDIA_COLUMNS, selection, null, null, String.valueOf(limit));
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Media media = this.cursorToEntity(this.cursor);
                this.listMedia.add(media);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listMedia;
    }

    @Override
    public boolean deleteAllMedia() {
        return super.delete("checkin_media", null, null) > 0;
    }

    @Override
    public boolean deleteMediaByReportId(int reportId) {
        String[] selectionArgs = new String[]{String.valueOf(reportId)};
        String selection = "_id =?";
        return super.delete("checkin_media", "_id =?", selectionArgs) > 0;
    }

    @Override
    public boolean deleteMediaByCheckinId(int checkinId) {
        String[] selectionArgs = new String[]{String.valueOf(checkinId)};
        String selection = "_id =?";
        return super.delete("checkin_media", "_id =?", selectionArgs) > 0;
    }

    @Override
    public boolean updateMediaByReportId(int reportId) {
        return false;
    }

    @Override
    public boolean updateMediaByCheckinId(int checkinId) {
        return false;
    }

    @Override
    public boolean deleteReportMediaByIdAndLink(int reportId, String link) {
        String[] selectionArgs = new String[]{String.valueOf(reportId), link};
        String selection = "_id =? AND media_link =?";
        return super.delete("checkin_media", "_id =? AND media_link =?", selectionArgs) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMedia(List<Media> sMedia) {
        try {
            this.mDb.beginTransaction();
            for (Media media : sMedia) {
                this.addMedia(media);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    @Override
    public boolean addMedia(Media media) {
        this.setContentValue(media);
        return super.insert("checkin_media", this.getContentValue()) > 0L;
    }

    protected Media cursorToEntity(Cursor cursor) {
        Media media = new Media();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                media.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("media_report_id") != -1) {
                int reportIdIndex = cursor.getColumnIndexOrThrow("media_report_id");
                media.setReportId(cursor.getInt(reportIdIndex));
            }
            if (cursor.getColumnIndex("media_checkin_id") != -1) {
                int checkinIdIndex = cursor.getColumnIndexOrThrow("media_checkin_id");
                media.setCheckinId(cursor.getInt(checkinIdIndex));
            }
            if (cursor.getColumnIndex("media_type") != -1) {
                int typeIndex = cursor.getColumnIndexOrThrow("media_type");
                media.setType(cursor.getInt(typeIndex));
            }
            if (cursor.getColumnIndex("media_link") != -1) {
                int linkIndex = cursor.getColumnIndexOrThrow("media_link");
                media.setLink(cursor.getString(linkIndex));
            }
        }
        return media;
    }

    private void setContentValue(Media media) {
        this.initialValues = new ContentValues();
        this.initialValues.put("media_id", Integer.valueOf(media.getMediaId()));
        this.initialValues.put("media_report_id", Integer.valueOf(media.getReportId()));
        this.initialValues.put("media_checkin_id", Integer.valueOf(media.getCheckinId()));
        this.initialValues.put("media_type", Integer.valueOf(media.getType()));
        this.initialValues.put("media_link", media.getLink());
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    @Override
    public boolean deleteReportNews(int reportId) {
        String[] selectionArgs = new String[]{String.valueOf(reportId), String.valueOf(4)};
        String selection = "media_report_id =? AND media_type =?";
        return super.delete("checkin_media", "media_report_id =? AND media_type =?", selectionArgs) > 0;
    }

    @Override
    public boolean deleteReportPhoto(int reportId) {
        String[] selectionArgs = new String[]{String.valueOf(reportId), String.valueOf(1)};
        String selection = "media_report_id =? AND media_type =?";
        return super.delete("checkin_media", "media_report_id =? AND media_type =?", selectionArgs) > 0;
    }

    @Override
    public boolean deleteCheckinPhoto(int checkinId) {
        String[] selectionArgs = new String[]{String.valueOf(checkinId), String.valueOf(1)};
        String selection = "media_checkin_id =? AND media_type =?";
        return super.delete("checkin_media", "media_checkin_id =? AND media_type =?", selectionArgs) > 0;
    }
}

