/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IOfflineReportDao;
import com.ushahidi.android.app.database.IOfflineReportSchema;
import com.ushahidi.android.app.entities.OfflineReport;
import java.util.ArrayList;
import java.util.List;

public class OfflineReportDao
extends DbContentProvider
implements IOfflineReportDao,
IOfflineReportSchema {
    private Cursor cursor;
    private List<OfflineReport> listOfflineReport;
    private ContentValues initialValues;

    public OfflineReportDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<OfflineReport> fetchAllOfflineIncidents() {
        String sortOrder = "incident_date DESC";
        this.listOfflineReport = new ArrayList<OfflineReport>();
        this.cursor = super.query("offline_report", null, null, null, "incident_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                OfflineReport offlineReport = this.cursorToEntity(this.cursor);
                this.listOfflineReport.add(offlineReport);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listOfflineReport;
    }

    @Override
    public boolean deleteAllOfflineReport() {
        return super.delete("offline_report", null, null) > 0;
    }

    @Override
    public boolean addOfflineReport(OfflineReport offlineReport) {
        this.setContentValue(offlineReport);
        return super.insert("offline_report", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOfflineReport(List<OfflineReport> offlineReports) {
        try {
            this.mDb.beginTransaction();
            for (OfflineReport offlineReport : offlineReports) {
                this.addOfflineReport(offlineReport);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    protected OfflineReport cursorToEntity(Cursor cursor) {
        OfflineReport offlineReport = new OfflineReport();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                offlineReport.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("incident_title") != -1) {
                int titleIndex = cursor.getColumnIndexOrThrow("incident_title");
                offlineReport.setTitle(cursor.getString(titleIndex));
            }
            if (cursor.getColumnIndex("incident_date") != -1) {
                int dateIndex = cursor.getColumnIndexOrThrow("incident_date");
                offlineReport.setDate(cursor.getString(dateIndex));
            }
            if (cursor.getColumnIndex("incident_hour") != -1) {
                int hourIndex = cursor.getColumnIndexOrThrow("incident_hour");
                offlineReport.setHour(cursor.getInt(hourIndex));
            }
            if (cursor.getColumnIndex("incident_loc_name") != -1) {
                int locationIndex = cursor.getColumnIndexOrThrow("incident_loc_name");
                offlineReport.setLocationName(cursor.getString(locationIndex));
            }
            if (cursor.getColumnIndex("incident_desc") != -1) {
                int descIndex = cursor.getColumnIndexOrThrow("incident_desc");
                offlineReport.setDescription(cursor.getString(descIndex));
            }
            if (cursor.getColumnIndex("incident_categories") != -1) {
                int categoryIndex = cursor.getColumnIndexOrThrow("incident_categories");
                offlineReport.setCategories(cursor.getString(categoryIndex));
            }
            if (cursor.getColumnIndex("incident_photo") != -1) {
                int photoIndex = cursor.getColumnIndexOrThrow("incident_photo");
                offlineReport.setPhoto(cursor.getString(photoIndex));
            }
            if (cursor.getColumnIndex("incident_video") != -1) {
                int videoIndex = cursor.getColumnIndexOrThrow("incident_video");
                offlineReport.setVideo(cursor.getString(videoIndex));
            }
            if (cursor.getColumnIndex("incident_loc_latitude") != -1) {
                int latitudeIndex = cursor.getColumnIndexOrThrow("incident_loc_latitude");
                offlineReport.setLatitude(cursor.getString(latitudeIndex));
            }
            if (cursor.getColumnIndex("incident_loc_longitude") != -1) {
                int longitudeIndex = cursor.getColumnIndexOrThrow("incident_loc_longitude");
                offlineReport.setLongitude(cursor.getString(longitudeIndex));
            }
            if (cursor.getColumnIndex("incident_news") != -1) {
                int newsIndex = cursor.getColumnIndexOrThrow("incident_news");
                offlineReport.setNews(cursor.getString(newsIndex));
            }
            if (cursor.getColumnIndex("incident_ampm") != -1) {
                int ampmIndex = cursor.getColumnIndexOrThrow("incident_ampm");
                offlineReport.setAmPm(cursor.getString(ampmIndex));
            }
            if (cursor.getColumnIndex("person_first") != -1) {
                int firstnameIndex = cursor.getColumnIndexOrThrow("person_first");
                offlineReport.setFirstName(cursor.getString(firstnameIndex));
            }
            if (cursor.getColumnIndex("person_last") != -1) {
                int lastnameIndex = cursor.getColumnIndexOrThrow("person_last");
                offlineReport.setLastName(cursor.getString(lastnameIndex));
            }
            if (cursor.getColumnIndex("person_email") != -1) {
                int emailIndex = cursor.getColumnIndexOrThrow("person_email");
                offlineReport.setEmail(cursor.getString(emailIndex));
            }
        }
        return offlineReport;
    }

    private void setContentValue(OfflineReport offlineReport) {
        this.initialValues = new ContentValues();
        this.initialValues.put("incident_title", offlineReport.getTitle());
        this.initialValues.put("incident_desc", offlineReport.getDescription());
        this.initialValues.put("incident_date", offlineReport.getDate());
        this.initialValues.put("incident_hour", Integer.valueOf(offlineReport.getHour()));
        this.initialValues.put("incident_minute", Integer.valueOf(offlineReport.getMinute()));
        this.initialValues.put("incident_ampm", offlineReport.getAmPm());
        this.initialValues.put("incident_categories", offlineReport.getCategories());
        this.initialValues.put("incident_loc_name", offlineReport.getLocationName());
        this.initialValues.put("incident_loc_latitude", offlineReport.getLatitude());
        this.initialValues.put("incident_loc_longitude", offlineReport.getLongitude());
        this.initialValues.put("incident_photo", offlineReport.getPhoto());
        this.initialValues.put("incident_video", offlineReport.getVideo());
        this.initialValues.put("incident_news", offlineReport.getNews());
        this.initialValues.put("person_first", offlineReport.getFirstName());
        this.initialValues.put("person_last", offlineReport.getLastName());
        this.initialValues.put("person_email", offlineReport.getEmail());
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }
}

