/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.IOpenGeoSmsDao;
import com.ushahidi.android.app.database.IOpenGeoSmsSchema;

public class OpenGeoSmsDao
implements IOpenGeoSmsDao,
IOpenGeoSmsSchema {
    private SQLiteDatabase mDb;
    private static final String WHERE = "report_id=?";

    public OpenGeoSmsDao(SQLiteDatabase db) {
        this.mDb = db;
    }

    private static String[] array(String ... strs) {
        return strs;
    }

    private static String[] array(long i) {
        return new String[]{String.valueOf(i)};
    }

    @Override
    public int getReportState(long reportId) {
        Cursor c = this.mDb.query("opengeosms", OpenGeoSmsDao.array("state"), WHERE, OpenGeoSmsDao.array(reportId), null, null, null);
        if (c.getCount() < 1) {
            return -1;
        }
        c.moveToFirst();
        return c.getInt(0);
    }

    @Override
    public boolean addReport(long reportId) {
        ContentValues cv = new ContentValues();
        cv.put("report_id", Long.valueOf(reportId));
        cv.put("state", Integer.valueOf(0));
        return this.mDb.insert("opengeosms", null, cv) != -1L;
    }

    @Override
    public boolean setReportState(long reportId, int state) {
        switch (state) {
            case 0: 
            case 1: {
                ContentValues cv = new ContentValues();
                cv.put("state", Integer.valueOf(state));
                return this.mDb.update("opengeosms", cv, WHERE, OpenGeoSmsDao.array(reportId)) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean deleteReport(long reportId) {
        return this.mDb.delete("opengeosms", WHERE, OpenGeoSmsDao.array(reportId)) > 0;
    }

    @Override
    public boolean deleteReports() {
        this.mDb.delete("opengeosms", null, null);
        return true;
    }
}

