/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IReportCategoryDao;
import com.ushahidi.android.app.database.IReportCategorySchema;
import com.ushahidi.android.app.entities.ReportCategory;
import java.util.ArrayList;
import java.util.List;

public class ReportCategoryDao
extends DbContentProvider
implements IReportCategoryDao,
IReportCategorySchema {
    private Cursor cursor;
    private List<ReportCategory> listReportCategories;
    private ContentValues initialValues;

    public ReportCategoryDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<ReportCategory> fetchReportCategory(long reportId) {
        this.listReportCategories = new ArrayList<ReportCategory>();
        String[] selectionArgs = new String[]{String.valueOf(reportId)};
        String selection = "_id =?";
        this.cursor = super.query("report_category", COLUMNS, "_id =?", selectionArgs, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                ReportCategory reportCategory = this.cursorToEntity(this.cursor);
                this.listReportCategories.add(reportCategory);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReportCategories;
    }

    @Override
    public List<ReportCategory> fetchReportCategoryByReportId(int reportId) {
        this.listReportCategories = new ArrayList<ReportCategory>();
        String[] selectionArgs = new String[]{String.valueOf(reportId)};
        String selection = "report_id =?";
        this.cursor = super.query("report_category", COLUMNS, "report_id =?", selectionArgs, null);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                ReportCategory reportCategory = this.cursorToEntity(this.cursor);
                this.listReportCategories.add(reportCategory);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReportCategories;
    }

    @Override
    public boolean addReportCategory(ReportCategory reportCategory) {
        this.setContentValue(reportCategory);
        return super.insert("report_category", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addReportCategories(List<ReportCategory> reportCategories) {
        try {
            this.mDb.beginTransaction();
            for (ReportCategory reportCategory : reportCategories) {
                this.addReportCategory(reportCategory);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    @Override
    public boolean deleteAllReportCategory() {
        return super.delete("report_category", null, null) > 0;
    }

    protected ReportCategory cursorToEntity(Cursor cursor) {
        ReportCategory reportCategory = new ReportCategory();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                reportCategory.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("report_id") != -1) {
                int reportIdIndex = cursor.getColumnIndexOrThrow("report_id");
                reportCategory.setReportId(cursor.getInt(reportIdIndex));
            }
            if (cursor.getColumnIndex("category_id") != -1) {
                int categoryIdIndex = cursor.getColumnIndexOrThrow("category_id");
                reportCategory.setCategoryId(cursor.getInt(categoryIdIndex));
            }
        }
        return reportCategory;
    }

    private void setContentValue(ReportCategory reportCategory) {
        this.initialValues = new ContentValues();
        this.initialValues.put("report_id", Integer.valueOf(reportCategory.getReportId()));
        this.initialValues.put("category_id", Integer.valueOf(reportCategory.getCategoryId()));
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    @Override
    public boolean deleteReportCategoryByReportId(int reportId) {
        String[] selectionArgs = new String[]{String.valueOf(reportId)};
        String selection = "report_id =?";
        return super.delete("report_category", "report_id =?", selectionArgs) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateReportCategory(int reportId, ReportCategory reportCategory) {
        boolean status = false;
        try {
            this.mDb.beginTransaction();
            String[] selectionArgs = new String[]{String.valueOf(reportId)};
            String selection = "report_id =?";
            this.setContentValue(reportCategory);
            status = super.update("report_category", this.getContentValue(), "report_id =?", selectionArgs) > 0;
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return status;
    }
}

