/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IReportDao;
import com.ushahidi.android.app.database.IReportSchema;
import com.ushahidi.android.app.entities.Report;
import java.util.ArrayList;
import java.util.List;

public class ReportDao
extends DbContentProvider
implements IReportDao,
IReportSchema {
    private Cursor cursor;
    private List<Report> listReport;
    private ContentValues initialValues;

    public ReportDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<Report> fetchAllPendingReports() {
        String sortOrder = "incident_date DESC";
        String selection = "pending =?";
        String[] selectionArgs = new String[]{String.valueOf(1)};
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", null, "pending =?", selectionArgs, "incident_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public List<Report> fetchAllReports() {
        String sortOrder = "incident_date DESC";
        String selection = "pending = ?";
        String[] selectionArgs = new String[]{String.valueOf(0)};
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", null, "pending = ?", selectionArgs, "incident_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public List<Report> fetchPendingReportByCategory(String category) {
        String sortOrder = "incident_title DESC";
        String[] selectionArgs = new String[]{category, String.valueOf(1)};
        String selection = "incident_categories LIKE ? AND pending =? ";
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", null, "incident_categories LIKE ? AND pending =? ", selectionArgs, "incident_title DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public int fetchPendingReportIdByDate(String date) {
        String sortOrder = "_id DESC";
        String[] selectionArgs = new String[]{date, String.valueOf(1)};
        String selection = "incident_date =? AND pending =? ";
        int id2 = 0;
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", null, "incident_date =? AND pending =? ", selectionArgs, "_id DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                id2 = report.getDbId();
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return id2;
    }

    @Override
    public List<Report> fetchReportByCategory(String category) {
        String sortOrder = "incident_title DESC";
        String[] selectionArgs = new String[]{category};
        String selection = "incident_categories LIKE ?";
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", null, "incident_categories LIKE ?", selectionArgs, "incident_title DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public List<Report> fetchPendingReportByCategoryId(int categoryId) {
        String sortOrder = "incident_title DESC";
        String sql = "SELECT reports.* FROM incidents reports INNER JOIN report_category cats ON reports._id = cats.report_id WHERE cats.category_id =? AND pending=? ORDER BY  incident_title DESC";
        String[] selectionArgs = new String[]{String.valueOf(categoryId), String.valueOf(1)};
        this.listReport = new ArrayList<Report>();
        this.cursor = super.rawQuery("SELECT reports.* FROM incidents reports INNER JOIN report_category cats ON reports._id = cats.report_id WHERE cats.category_id =? AND pending=? ORDER BY  incident_title DESC", selectionArgs);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public List<Report> fetchReportByCategoryId(int categoryId) {
        String sortOrder = "incident_title DESC";
        String sql = "SELECT * FROM incidents reports INNER JOIN report_category cats ON reports.incident_id = cats.report_id WHERE cats.category_id =? AND pending=? ORDER BY  incident_title DESC";
        String[] selectionArgs = new String[]{String.valueOf(categoryId), String.valueOf(0)};
        this.listReport = new ArrayList<Report>();
        this.cursor = super.rawQuery("SELECT * FROM incidents reports INNER JOIN report_category cats ON reports.incident_id = cats.report_id WHERE cats.category_id =? AND pending=? ORDER BY  incident_title DESC", selectionArgs);
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public List<Report> fetchReportById(long id2) {
        String sortOrder = "incident_title";
        String[] selectionArgs = new String[]{String.valueOf(id2)};
        String selection = "incident_id = ?";
        this.listReport = new ArrayList<Report>();
        this.cursor = super.query("incidents", INCIDENTS_COLUMNS, "incident_id = ?", selectionArgs, "incident_title");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                Report report = this.cursorToEntity(this.cursor);
                this.listReport.add(report);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listReport;
    }

    @Override
    public Report fetchPendingReportIdById(int reportId) {
        String sortOrder = "incident_date DESC";
        String[] selectionArgs = new String[]{String.valueOf(reportId), String.valueOf(1)};
        String selection = "_id =? AND pending =? ";
        Report report = new Report();
        this.cursor = super.query("incidents", null, "_id =? AND pending =? ", selectionArgs, "incident_date DESC");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                report = this.cursorToEntity(this.cursor);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return report;
    }

    @Override
    public boolean deleteAllReport() {
        return super.delete("incidents", null, null) > 0;
    }

    @Override
    public boolean deleteReportById(long id2) {
        String[] selectionArgs = new String[]{String.valueOf(id2)};
        String selection = "incident_id = ?";
        return super.delete("incidents", "incident_id = ?", selectionArgs) > 0;
    }

    @Override
    public boolean addReport(Report report) {
        this.setContentValue(report);
        return super.insert("incidents", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addReport(List<Report> reports) {
        try {
            this.mDb.beginTransaction();
            for (Report report : reports) {
                this.addReport(report);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    protected Report cursorToEntity(Cursor cursor) {
        Report report = new Report();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                report.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("incident_id") != -1) {
                int reportIdIndex = cursor.getColumnIndexOrThrow("incident_id");
                report.setReportId(cursor.getInt(reportIdIndex));
            }
            if (cursor.getColumnIndex("incident_title") != -1) {
                int titleIndex = cursor.getColumnIndexOrThrow("incident_title");
                report.setTitle(cursor.getString(titleIndex));
            }
            if (cursor.getColumnIndex("incident_date") != -1) {
                int dateIndex = cursor.getColumnIndexOrThrow("incident_date");
                report.setReportDate(cursor.getString(dateIndex));
            }
            if (cursor.getColumnIndex("incident_verified") != -1) {
                int verifiedIndex = cursor.getColumnIndexOrThrow("incident_verified");
                report.setVerified(cursor.getString(verifiedIndex));
            }
            if (cursor.getColumnIndex("incident_loc_name") != -1) {
                int locationIndex = cursor.getColumnIndexOrThrow("incident_loc_name");
                report.setLocationName(cursor.getString(locationIndex));
            }
            if (cursor.getColumnIndex("incident_desc") != -1) {
                int descIndex = cursor.getColumnIndexOrThrow("incident_desc");
                report.setDescription(cursor.getString(descIndex));
            }
            if (cursor.getColumnIndex("incident_media") != -1) {
                int mediaIndex = cursor.getColumnIndexOrThrow("incident_media");
                report.setMedia(cursor.getString(mediaIndex));
            }
            if (cursor.getColumnIndex("incident_image") != -1) {
                int imageIndex = cursor.getColumnIndexOrThrow("incident_image");
                report.setImage(cursor.getString(imageIndex));
            }
            if (cursor.getColumnIndex("incident_loc_latitude") != -1) {
                int latitudeIndex = cursor.getColumnIndexOrThrow("incident_loc_latitude");
                report.setLatitude(cursor.getString(latitudeIndex));
            }
            if (cursor.getColumnIndex("incident_loc_longitude") != -1) {
                int longitudeIndex = cursor.getColumnIndexOrThrow("incident_loc_longitude");
                report.setLongitude(cursor.getString(longitudeIndex));
            }
        }
        return report;
    }

    private void setContentValue(Report report) {
        this.initialValues = new ContentValues();
        this.initialValues.put("incident_id", Integer.valueOf(report.getReportId()));
        this.initialValues.put("incident_title", report.getTitle());
        this.initialValues.put("incident_desc", report.getDescription());
        this.initialValues.put("incident_date", report.getReportDate());
        this.initialValues.put("incident_mode", report.getMode());
        this.initialValues.put("incident_verified", report.getVerified());
        this.initialValues.put("incident_loc_name", report.getLocationName());
        this.initialValues.put("incident_loc_latitude", report.getLatitude());
        this.initialValues.put("incident_loc_longitude", report.getLongitude());
        this.initialValues.put("pending", Integer.valueOf(report.getPending()));
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }

    @Override
    public boolean deletePendingReportById(int id2) {
        String[] selectionArgs = new String[]{String.valueOf(id2), String.valueOf(1)};
        String selection = "_id = ? AND pending = ?";
        return super.delete("incidents", "_id = ? AND pending = ?", selectionArgs) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePendingReport(int reportId, Report report) {
        boolean status = false;
        try {
            this.mDb.beginTransaction();
            String[] selectionArgs = new String[]{String.valueOf(reportId), String.valueOf(1)};
            String selection = "_id = ? AND pending = ?";
            this.setContentValue(report);
            super.update("incidents", this.getContentValue(), "_id = ? AND pending = ?", selectionArgs);
            this.mDb.setTransactionSuccessful();
            status = true;
        }
        finally {
            this.mDb.endTransaction();
        }
        return status;
    }
}

