/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ushahidi.android.app.database.DbContentProvider;
import com.ushahidi.android.app.database.IUserDao;
import com.ushahidi.android.app.database.IUserSchema;
import com.ushahidi.android.app.entities.User;
import java.util.ArrayList;
import java.util.List;

public class UserDao
extends DbContentProvider
implements IUserSchema,
IUserDao {
    private Cursor cursor;
    private List<User> listUser;
    private ContentValues initialValues;

    public UserDao(SQLiteDatabase db) {
        super(db);
    }

    @Override
    public List<User> fetchUsersById(int userId) {
        String[] selectionArgs = new String[]{String.valueOf(userId)};
        String selection = "user_id = ?";
        this.listUser = new ArrayList<User>();
        this.cursor = super.query("users", USER_COLUMNS, "user_id = ?", selectionArgs, "user_name");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                User user = this.cursorToEntity(this.cursor);
                this.listUser.add(user);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listUser;
    }

    @Override
    public List<User> fetchUsers() {
        this.listUser = new ArrayList<User>();
        this.cursor = super.query("users", USER_COLUMNS, null, null, "_id");
        if (this.cursor != null) {
            this.cursor.moveToFirst();
            while (!this.cursor.isAfterLast()) {
                User user = this.cursorToEntity(this.cursor);
                this.listUser.add(user);
                this.cursor.moveToNext();
            }
            this.cursor.close();
        }
        return this.listUser;
    }

    @Override
    public boolean addUser(User user) {
        this.setContentValue(user);
        return super.insert("users", this.getContentValue()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUser(List<User> users) {
        try {
            this.mDb.beginTransaction();
            for (User user : users) {
                this.addUser(user);
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        return true;
    }

    @Override
    public boolean deleteAllUsers() {
        return super.delete("users", null, null) > 0;
    }

    protected User cursorToEntity(Cursor cursor) {
        User user = new User();
        if (cursor != null) {
            if (cursor.getColumnIndex("_id") != -1) {
                int idIndex = cursor.getColumnIndexOrThrow("_id");
                user.setDbId(cursor.getInt(idIndex));
            }
            if (cursor.getColumnIndex("user_id") != -1) {
                int userIdIndex = cursor.getColumnIndexOrThrow("user_id");
                user.setUserId(cursor.getInt(userIdIndex));
            }
            if (cursor.getColumnIndex("user_color") != -1) {
                int userColorIndex = cursor.getColumnIndexOrThrow("user_color");
                user.setColor(cursor.getString(userColorIndex));
            }
            if (cursor.getColumnIndex("user_color") != -1) {
                int usernameIndex = cursor.getColumnIndexOrThrow("user_name");
                user.setUsername(cursor.getString(usernameIndex));
            }
        }
        return user;
    }

    private void setContentValue(User user) {
        this.initialValues = new ContentValues();
        this.initialValues.put("user_id", Integer.valueOf(user.getUserId()));
        this.initialValues.put("user_name", user.getUsername());
        this.initialValues.put("user_color", user.getColor());
    }

    private ContentValues getContentValue() {
        return this.initialValues;
    }
}

