/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.fragments;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.ListFragment;
import android.support.v4.view.Menu;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.Toast;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseSectionListAdapter;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.util.Objects;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.View;
import java.lang.reflect.InvocationTargetException;

public abstract class BaseSectionListFragment<V extends View, M extends Model, L extends BaseSectionListAdapter<M>>
extends ListFragment {
    private final int listViewId;
    private final Class<L> adapterClass;
    protected L adapter;
    protected ListView listView;
    protected final int menu;
    protected final int layout;
    protected final Class<V> viewClass;
    protected V view;

    protected BaseSectionListFragment(Class<V> view, Class<L> adapter, int layout2, int menu, int listView) {
        this.adapterClass = adapter;
        this.listViewId = listView;
        this.viewClass = view;
        this.menu = menu;
        this.layout = layout2;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.listViewId != 0) {
            android.view.View emptyView;
            this.listView = this.getListView();
            if (this.headerView() != null) {
                this.listView.addHeaderView(this.headerView());
            }
            if ((emptyView = this.getActivity().findViewById(16908292)) != null) {
                this.listView.setEmptyView(emptyView);
            }
            this.view = (View)Objects.createInstance(this.viewClass, Activity.class, this.getActivity());
            this.adapter = (BaseSectionListAdapter)((Object)Objects.createInstance(this.adapterClass, Context.class, this.getActivity()));
            this.listView.setAdapter(this.adapter);
            this.listView.setFocusable(true);
            this.listView.setFocusableInTouchMode(true);
        }
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.menu != 0) {
            inflater.inflate(this.menu, (android.view.Menu)menu);
        }
    }

    @Override
    public android.view.View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        android.view.View root = null;
        if (this.layout != 0) {
            root = inflater.inflate(this.layout, container, false);
        }
        return root;
    }

    protected abstract void onLoaded(boolean var1);

    protected abstract android.view.View headerView();

    protected M getSelectedItem() {
        return (M)((Model)this.listView.getSelectedItem());
    }

    public void onItemSelected(AdapterView<?> adapterView, android.view.View view, int position, long id2) {
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }

    protected void toastLong(String message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)message, (int)1).show();
    }

    protected void toastLong(int message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)this.getText(message), (int)1).show();
    }

    protected void toastShort(int message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)this.getText(message), (int)0).show();
    }

    protected void toastShort(CharSequence message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)message.toString(), (int)0).show();
    }

    protected <T> T createInstance(Class<?> type, Class<?> constructor, Object ... params) {
        try {
            return (T)type.getConstructor(constructor).newInstance(params);
        }
        catch (Fragment.InstantiationException e) {
            this.log("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            this.log("IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            this.log("InvocationTargetException", e);
        }
        catch (NoSuchMethodException e) {
            this.log("NoSuchMethodException", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected class LoadingTask
    extends ProgressTask {
        public LoadingTask(Activity activity) {
            super(activity, R.string.loading_);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog.cancel();
        }

        protected Boolean doInBackground(String ... args) {
            ((BaseSectionListAdapter)((Object)BaseSectionListFragment.this.adapter)).refresh();
            return true;
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            BaseSectionListFragment.this.onLoaded(success);
            BaseSectionListFragment.this.listView.setAdapter(BaseSectionListFragment.this.adapter);
        }
    }
}

