/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.helpers;

import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.ui.phone.ListMapActivity;
import com.ushahidi.android.app.ui.tablet.ListMapFragment;

public class ActionModeHelper
implements ActionMode.Callback,
AdapterView.OnItemLongClickListener {
    private ListMapActivity host;
    private ListMapFragment listMapFragment;
    private ActionMode activeMode;
    private ListView modeView;
    private int lastPosition = -1;

    public ActionModeHelper(ListMapActivity host, ListView modeView) {
        this.host = host;
        this.modeView = modeView;
    }

    public ActionModeHelper(ListMapFragment listMapFragment, ListView listView) {
        this.listMapFragment = listMapFragment;
        this.modeView = listView;
    }

    public boolean onItemLongClick(AdapterView<?> view, View row, int position, long id2) {
        this.lastPosition = position;
        this.modeView.clearChoices();
        this.modeView.setItemChecked(this.lastPosition, true);
        if (this.activeMode == null) {
            if (this.host != null) {
                this.activeMode = this.host.startActionMode(this);
            }
            if (this.listMapFragment != null) {
                this.activeMode = this.listMapFragment.getActivity().startActionMode((ActionMode.Callback)this);
            }
        }
        return true;
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        MenuInflater inflater;
        if (this.host != null) {
            inflater = this.host.getMenuInflater();
            inflater.inflate(R.menu.list_map_context, menu2);
            mode.setTitle(R.string.map);
        }
        if (this.listMapFragment != null) {
            inflater = this.listMapFragment.getActivity().getMenuInflater();
            inflater.inflate(R.menu.list_map_context, menu2);
            this.listMapFragment.getActivity().setTitle(R.string.map);
        }
        return true;
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        return false;
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        boolean result = false;
        if (this.host != null) {
            result = this.host.performAction(item, this.lastPosition);
        }
        if (this.listMapFragment != null) {
            result = this.listMapFragment.performAction(item, this.lastPosition);
        }
        return result;
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.activeMode = null;
        this.modeView.clearChoices();
    }
}

