/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.helpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.util.PhotoUtils;

public class RoundedCornerImageView
extends ImageView {
    private float cornerRadius;
    private float bitmapCornerRadius;

    public RoundedCornerImageView(Context context) {
        super(context);
    }

    public RoundedCornerImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getXMLAttribute(context, attrs);
    }

    public RoundedCornerImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.getXMLAttribute(context, attrs);
    }

    private void getXMLAttribute(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundedCornerImageView);
        this.cornerRadius = a.getDimension(R.styleable.RoundedCornerImageView_cornerRadius, 0.0f);
        a.recycle();
    }

    public void setCornerRadius(int radius) {
        this.cornerRadius = radius;
    }

    protected void onDraw(Canvas canvas) {
        boolean applyCornerToBitmap = false;
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            int bitmapWidth;
            float newBitmapCornerRadius;
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            int viewWidth = this.getWidth();
            if ((float)viewWidth != 0.0f && this.bitmapCornerRadius != (newBitmapCornerRadius = this.cornerRadius * (float)(bitmapWidth = bitmap.getWidth()) / (float)viewWidth)) {
                applyCornerToBitmap = true;
                int bitmapHeight = bitmap.getHeight();
                this.bitmapCornerRadius = newBitmapCornerRadius;
                bitmap = PhotoUtils.getRoundedCornerBitmap(bitmap, this.bitmapCornerRadius, bitmapWidth, bitmapHeight, false, false, false, false);
                this.setImageBitmap(bitmap);
            }
        }
        if (!applyCornerToBitmap) {
            super.onDraw(canvas);
        }
    }
}

