/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.helpers;

import android.content.Context;
import android.support.v4.app.ActionBar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentMapActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.ViewPager;
import com.ushahidi.android.app.helpers.ReportViewPager;
import java.util.ArrayList;

public class TabsAdapter
extends FragmentPagerAdapter
implements ViewPager.OnPageChangeListener,
ActionBar.TabListener {
    private final Context mContext;
    private final ActionBar mActionBar;
    private final ReportViewPager mViewPager;
    private final ArrayList<String> mTabs = new ArrayList();

    public TabsAdapter(FragmentMapActivity activity, ActionBar actionBar, ReportViewPager pager) {
        super(activity.getSupportFragmentManager());
        this.mContext = activity;
        this.mActionBar = actionBar;
        this.mViewPager = pager;
        this.mViewPager.setAdapter(this);
        this.mViewPager.setOffscreenPageLimit(3);
        this.mViewPager.setPagingEnabled(false);
        this.mViewPager.setOnPageChangeListener(this);
    }

    public void addTab(ActionBar.Tab tab, Class<?> clss) {
        this.mTabs.add(clss.getName());
        this.mActionBar.addTab(tab.setTabListener(this));
        this.notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return this.mTabs.size();
    }

    @Override
    public Fragment getItem(int position) {
        return Fragment.instantiate(this.mContext, this.mTabs.get(position), null);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    @Override
    public void onPageSelected(int position) {
        this.mActionBar.setSelectedNavigationItem(position);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void onTabSelected(ActionBar.Tab tab, FragmentTransaction ft) {
        this.mViewPager.setCurrentItem(tab.getPosition());
    }

    @Override
    public void onTabReselected(ActionBar.Tab tab, FragmentTransaction ft) {
    }

    @Override
    public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction ft) {
    }
}

