/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.Model;
import java.io.File;
import java.util.List;

public class AddCheckinModel
extends Model {
    public boolean addPendingCheckin(Checkin checkin, File[] pendingPhotos) {
        boolean status = Database.mCheckin.addCheckin(checkin);
        int id2 = Database.mCheckin.fetchPendingCheckinIdByDate(checkin.getDate());
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            for (File file : pendingPhotos) {
                if (!file.exists()) continue;
                Media media = new Media();
                media.setMediaId(0);
                media.setLink(file.getName());
                media.setCheckinId(id2);
                media.setType(1);
                Database.mMediaDao.addMedia(media);
            }
        }
        return status;
    }

    public boolean updatePendingCheckin(int checkinId, Checkin checkin, List<Photo> pendingPhotos) {
        boolean status = Database.mCheckin.updatePendingCheckin(checkinId, checkin);
        if (pendingPhotos != null && pendingPhotos.size() > 0) {
            Database.mMediaDao.deleteReportPhoto(checkinId);
            for (Photo photo : pendingPhotos) {
                Media media = new Media();
                media.setMediaId(0);
                String[] sections = photo.getPhoto().split("/");
                media.setLink(sections[1]);
                media.setCheckinId(checkinId);
                media.setType(1);
                Database.mMediaDao.addMedia(media);
            }
        }
        return status;
    }

    public boolean deleteCheckin(int checkinId) {
        Database.mCheckin.deletePendingCheckinById(checkinId);
        Database.mMediaDao.deleteMediaByCheckinId(checkinId);
        return true;
    }

    public Checkin fetchPendingCheckinById(int checkinId) {
        return Database.mCheckin.fetchPendingCheckinById(checkinId);
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }
}

