/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.entities.Report;
import com.ushahidi.android.app.entities.ReportCategory;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.Util;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class AddReportModel
extends Model {
    public boolean addPendingReport(Report report, Vector<String> category, File[] pendingPhotos, String news) {
        boolean status = Database.mReportDao.addReport(report);
        int id2 = Database.mReportDao.fetchPendingReportIdByDate(report.getReportDate());
        report.setDbId(id2);
        if (status) {
            if (category != null && category.size() > 0) {
                for (String cat : category) {
                    ReportCategory reportCategory = new ReportCategory();
                    reportCategory.setCategoryId(Util.toInt(cat));
                    reportCategory.setReportId(id2);
                    Database.mReportCategoryDao.addReportCategory(reportCategory);
                }
            }
            if (pendingPhotos != null && pendingPhotos.length > 0) {
                for (File file : pendingPhotos) {
                    if (!file.exists()) continue;
                    Media media = new Media();
                    media.setMediaId(0);
                    media.setLink(file.getName());
                    media.setReportId(id2);
                    media.setType(1);
                    Database.mMediaDao.addMedia(media);
                }
            }
            if (news != null && news.length() > 0) {
                Media media = new Media();
                media.setMediaId(0);
                media.setLink(news);
                media.setReportId(id2);
                media.setType(4);
                Database.mMediaDao.addMedia(media);
            }
        }
        return status;
    }

    public boolean updatePendingReport(int reportId, Report report, Vector<String> category, List<Photo> pendingPhotos, String news) {
        boolean status = Database.mReportDao.updatePendingReport(reportId, report);
        if (status) {
            if (category != null && category.size() > 0) {
                Database.mReportCategoryDao.deleteReportCategoryByReportId(reportId);
                for (String cat : category) {
                    ReportCategory reportCategory = new ReportCategory();
                    reportCategory.setCategoryId(Util.toInt(cat));
                    reportCategory.setReportId(reportId);
                    Database.mReportCategoryDao.addReportCategory(reportCategory);
                }
            }
            if (pendingPhotos != null && pendingPhotos.size() > 0) {
                Database.mMediaDao.deleteReportPhoto(reportId);
                for (Photo photo : pendingPhotos) {
                    Media media = new Media();
                    media.setMediaId(0);
                    String[] sections = photo.getPhoto().split("/");
                    media.setLink(sections[1]);
                    media.setReportId(reportId);
                    media.setType(1);
                    Database.mMediaDao.addMedia(media);
                }
            }
            if (news != null && news.length() > 0) {
                Database.mMediaDao.deleteReportNews(reportId);
                Media media = new Media();
                media.setMediaId(0);
                media.setLink(news);
                media.setReportId(reportId);
                media.setType(4);
                Database.mMediaDao.addMedia(media);
            }
        }
        return status;
    }

    public Report fetchPendingReportById(int reportId) {
        return Database.mReportDao.fetchPendingReportIdById(reportId);
    }

    public List<ReportCategory> fetchReportCategories(int reportId) {
        return Database.mReportCategoryDao.fetchReportCategoryByReportId(reportId);
    }

    public List<Media> fetchReportNews(int reportId) {
        return Database.mMediaDao.fetchReportNews(reportId);
    }

    public boolean deleteReport(int reportId) {
        Database.mReportDao.deletePendingReportById(reportId);
        Database.mReportCategoryDao.deleteReportCategoryByReportId(reportId);
        Database.mMediaDao.deleteMediaByReportId(reportId);
        return true;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }
}

