/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import android.content.Context;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.User;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ListCheckinModel
extends Checkin {
    List<Checkin> mCheckins;

    @Override
    public boolean load() {
        this.mCheckins = Database.mCheckin.fetchAllCheckins();
        return this.mCheckins != null;
    }

    public boolean loadCheckinByUser(int userid) {
        this.mCheckins = Database.mCheckin.fetchCheckinsByUserId(userid);
        return this.mCheckins != null;
    }

    public boolean loadPendingCheckin() {
        this.mCheckins = Database.mCheckin.fetchAllPendingCheckins();
        return this.mCheckins != null;
    }

    public boolean loadPendingCheckinByUser(int userid) {
        this.mCheckins = Database.mCheckin.fetchPendingCheckinsByUserId(userid);
        return this.mCheckins != null;
    }

    public List<ListCheckinModel> getCheckins(Context context) {
        ArrayList<ListCheckinModel> checkins = new ArrayList<ListCheckinModel>();
        String d = null;
        if (this.mCheckins != null && this.mCheckins.size() > 0) {
            for (Checkin item : this.mCheckins) {
                ListCheckinModel listCheckin = new ListCheckinModel();
                listCheckin.setDbId(item.getDbId());
                listCheckin.setCheckinId(item.getCheckinId());
                listCheckin.setUsername(this.getUsername(context, item.getUserId()));
                listCheckin.setDate(Util.formatDate("yyyy-MM-dd hh:mm:ss", item.getDate(), "MMMM dd, yyyy 'at' hh:mm:ss aaa"));
                listCheckin.setLocationLatitude(item.getLocationLatitude());
                listCheckin.setLocationLongitude(item.getLocationLongitude());
                listCheckin.setLocationName(item.getLocationName());
                listCheckin.setMessage(item.getMessage());
                listCheckin.setUserId(item.getUserId());
                d = item.getCheckinId() == 0 ? this.getImage(context, item.getDbId()) : this.getImage(context, item.getCheckinId());
                listCheckin.setThumbnail(d);
                checkins.add(listCheckin);
            }
        }
        return checkins;
    }

    private String getImage(Context context, int checkinId) {
        List<Media> sMedia = Database.mMediaDao.fetchMedia("media_checkin_id", checkinId, 1, 1);
        if (sMedia != null && sMedia.size() > 0) {
            return sMedia.get(0).getLink();
        }
        return null;
    }

    private String getUsername(Context context, int userId) {
        new Util().log("ListCheckinModel", "User Id " + userId);
        List<User> sUser = Database.mUserDao.fetchUsersById(userId);
        if (sUser != null && sUser.size() > 0) {
            return sUser.get(0).getUsername();
        }
        return context.getText(R.string.unknown).toString();
    }

    public boolean deleteAllFetchedCheckin(int checkinId) {
        if (Database.mCheckin.deleteAllCheckins()) {
            new Util().log("ListCheckinModel", "Checkin deleted");
        }
        if (Database.mUserDao.deleteAllUsers()) {
            new Util().log("Users: ", "Users deleted");
        }
        if (Database.mMediaDao.deleteCheckinPhoto(checkinId)) {
            new Util().log("Media", "Media deleted");
        }
        return true;
    }

    public boolean deleteCheckin() {
        if (Database.mCheckin.deleteAllCheckins()) {
            new Util().log("ListCheckinModel", "Checkin deleted");
        }
        if (Database.mUserDao.deleteAllUsers()) {
            new Util().log("Users: ", "Users deleted");
        }
        if (Database.mMediaDao.deleteAllMedia()) {
            new Util().log("Media", "Media deleted");
        }
        return true;
    }

    @Override
    public boolean save() {
        return false;
    }
}

