/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import android.util.Log;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Comment;
import java.util.ArrayList;
import java.util.List;

public class ListCommentModel
extends Comment {
    private List<Comment> mCommentModel;

    public boolean load(int reportId) {
        this.mCommentModel = Database.mCommentDao.fetchReportComment(reportId);
        return this.mCommentModel != null;
    }

    public boolean loadCheckinComment(int checkinId) {
        this.mCommentModel = Database.mCommentDao.fetchCheckinComment(checkinId);
        return this.mCommentModel != null;
    }

    public List<ListCommentModel> getComments() {
        ArrayList<ListCommentModel> comments = new ArrayList<ListCommentModel>();
        if (this.mCommentModel != null && this.mCommentModel.size() > 0) {
            ListCommentModel comment = new ListCommentModel();
            comment.setDbId(this.mCommentModel.get(0).getDbId());
            comment.setCommentAuthor(this.mCommentModel.get(0).getCommentAuthor());
            comment.setCommentDescription(this.mCommentModel.get(0).getCommentDescription());
            comment.setReportId(this.mCommentModel.get(0).getReportId());
            comment.setCommentId(this.mCommentModel.get(0).getCommentId());
            comment.setCommentDate(this.mCommentModel.get(0).getCommentDate());
            comments.add(comment);
        }
        return comments;
    }

    public int totalComments() {
        if (this.mCommentModel != null && this.mCommentModel.size() > 0) {
            return this.mCommentModel.size();
        }
        return 0;
    }

    public List<ListCommentModel> getCommentsByReportId(int reportId) {
        ArrayList<ListCommentModel> comments = new ArrayList<ListCommentModel>();
        this.mCommentModel = new ArrayList<Comment>();
        this.mCommentModel = Database.mCommentDao.fetchReportComment(reportId);
        if (this.mCommentModel != null && this.mCommentModel.size() > 0) {
            for (Comment item : this.mCommentModel) {
                ListCommentModel comment = new ListCommentModel();
                comment.setDbId(item.getDbId());
                comment.setCommentAuthor(item.getCommentAuthor());
                comment.setCommentDescription(item.getCommentDescription());
                comment.setReportId(item.getReportId());
                comment.setCommentId(item.getCommentId());
                comment.setCommentDate(item.getCommentDate());
                comments.add(comment);
            }
        }
        return comments;
    }

    public List<ListCommentModel> getCommentsByCheckinId(int checkinId) {
        ArrayList<ListCommentModel> comments = new ArrayList<ListCommentModel>();
        this.mCommentModel = new ArrayList<Comment>();
        this.mCommentModel = Database.mCommentDao.fetchCheckinComment(checkinId);
        if (this.mCommentModel != null && this.mCommentModel.size() > 0) {
            for (Comment item : this.mCommentModel) {
                ListCommentModel comment = new ListCommentModel();
                comment.setDbId(item.getDbId());
                comment.setCommentAuthor(item.getCommentAuthor());
                comment.setCommentDescription(item.getCommentDescription());
                comment.setCheckinId(item.getCheckinId());
                comment.setCommentId(item.getCommentId());
                comment.setCommentDate(item.getCommentDate());
                comments.add(comment);
            }
        }
        return comments;
    }

    public boolean deleteComments() {
        if (Database.mCommentDao.deleteAllComment()) {
            Log.i((String)"ListCommentModel", (String)"Comment deleted");
            return true;
        }
        Log.i((String)"ListCommentModel", (String)"Comment deletetion failed!");
        return false;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }
}

