/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import android.content.Context;
import com.ushahidi.android.app.MainApplication;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Map;
import com.ushahidi.android.app.models.Model;
import java.util.ArrayList;
import java.util.List;

public class ListMapModel
extends Model {
    public List<Map> mMaps = new ArrayList<Map>();
    public List<ListMapModel> mMapModel;
    private int id;
    private String name;
    private String desc;
    private String url;
    private String date;
    private String lat;
    private String lon;
    private int catId;
    private String active;
    private int mapId;

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLat() {
        return this.lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLon() {
        return this.lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setCatId(int catId) {
        this.catId = catId;
    }

    public int getCatId() {
        return this.catId;
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getMapId() {
        return this.mapId;
    }

    @Override
    public boolean load() {
        this.mMaps = Database.mMapDao.fetchAllMaps();
        return this.mMaps != null;
    }

    public void activateDeployment(Context context, int id2) {
        List<Map> listMap = Database.mMapDao.fetchMapById(id2);
        if (listMap != null & listMap.size() > 0) {
            Preferences.loadSettings(context);
            Preferences.activeDeployment = id2;
            Preferences.activeMapName = listMap.get(0).getName();
            Preferences.domain = listMap.get(0).getUrl();
            Preferences.deploymentLatitude = listMap.get(0).getLat();
            Preferences.deploymentLongitude = listMap.get(0).getLon();
            Preferences.saveSettings(context);
        }
    }

    @Override
    public boolean save() {
        return false;
    }

    public boolean addMap(List<Map> maps) {
        return Database.mMapDao.addMaps(maps);
    }

    public boolean deleteMapById(int id2) {
        return Database.mMapDao.deleteMapById(id2);
    }

    public boolean deleteAllMap(Context context) {
        Database.mMapDao.deleteAllMap();
        MainApplication.mDb.clearData();
        Preferences.loadSettings(context);
        Preferences.activeDeployment = 0;
        Preferences.domain = "";
        Preferences.deploymentLatitude = "0.0";
        Preferences.deploymentLongitude = "0.0";
        Preferences.saveSettings(context);
        return true;
    }

    public boolean updateMap(int id2, String name, String desc, String url) {
        Map map = new Map();
        map.setDbId(id2);
        map.setName(name);
        map.setDesc(desc);
        map.setUrl(url);
        return Database.mMapDao.updateMap(map);
    }

    public void setActivness(int id2) {
        Database.mMapDao.setActiveDeployment(id2);
    }

    public List<ListMapModel> loadMapById(int id2, int mapId) {
        this.mMapModel = new ArrayList<ListMapModel>();
        this.mMaps = Database.mMapDao.fetchMapByIdAndUrl(id2, mapId);
        if (this.mMaps != null && this.mMaps.size() > 0) {
            for (Map map : this.mMaps) {
                ListMapModel mapModel = new ListMapModel();
                mapModel.setId(map.getDbId());
                mapModel.setMapId(map.getMapId());
                mapModel.setActive(map.getActive());
                mapModel.setCatId(map.getCatId());
                mapModel.setDate(map.getDate());
                mapModel.setDesc(map.getDesc());
                mapModel.setLat(map.getLat());
                mapModel.setLon(map.getLon());
                mapModel.setName(map.getName());
                mapModel.setUrl(map.getUrl());
                this.mMapModel.add(mapModel);
            }
        }
        return this.mMapModel;
    }

    public List<ListMapModel> getMaps() {
        this.mMapModel = new ArrayList<ListMapModel>();
        if (this.mMaps != null && this.mMaps.size() > 0) {
            for (Map map : this.mMaps) {
                ListMapModel mapModel = new ListMapModel();
                mapModel.setId(map.getDbId());
                mapModel.setMapId(map.getMapId());
                mapModel.setActive(map.getActive());
                mapModel.setCatId(map.getCatId());
                mapModel.setDate(map.getDate());
                mapModel.setDesc(map.getDesc());
                mapModel.setLat(map.getLat());
                mapModel.setLon(map.getLon());
                mapModel.setName(map.getName());
                mapModel.setUrl(map.getUrl());
                this.mMapModel.add(mapModel);
            }
        }
        return this.mMapModel;
    }
}

