/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import android.content.Context;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.PhotoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ListPhotoModel
extends Model {
    private List<Media> mMedia;
    private List<Photo> mPhotoModel;
    private static final String FETCHED = "fetched/";
    private static final String PENDING = "pending/";

    @Override
    public boolean load() {
        return false;
    }

    public boolean load(int reportId) {
        this.mMedia = Database.mMediaDao.fetchReportPhoto(reportId);
        return this.mMedia != null;
    }

    public boolean loadCheckinPhoto(int checkinId) {
        this.mMedia = Database.mMediaDao.fetchCheckinPhoto(checkinId);
        return this.mMedia != null;
    }

    public List<Photo> getPhotos() {
        this.mPhotoModel = new ArrayList<Photo>();
        if (this.mMedia != null && this.mMedia.size() > 0) {
            Photo photo = new Photo();
            photo.setDbId(this.mMedia.get(0).getDbId());
            photo.setPhoto(this.mMedia.get(0).getLink());
            this.mPhotoModel.add(photo);
        }
        return this.mPhotoModel;
    }

    public List<Photo> getPendingPhotos(Context context) {
        this.mPhotoModel = new ArrayList<Photo>();
        File[] pendingPhotos = PhotoUtils.getPendingPhotos(context);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            int id2 = 0;
            for (File file : pendingPhotos) {
                if (!file.exists()) continue;
                Photo photo = new Photo();
                photo.setDbId(++id2);
                photo.setPhoto(PENDING + file.getName());
                this.mPhotoModel.add(photo);
            }
        }
        return this.mPhotoModel;
    }

    public List<Photo> getPhotosByReportId(int reportId) {
        this.mPhotoModel = new ArrayList<Photo>();
        this.mMedia = Database.mMediaDao.fetchReportPhoto(reportId);
        if (this.mMedia != null && this.mMedia.size() > 0) {
            for (Media item : this.mMedia) {
                Photo photo = new Photo();
                photo.setDbId(item.getDbId());
                photo.setPhoto(item.getLink());
                this.mPhotoModel.add(photo);
            }
        }
        return this.mPhotoModel;
    }

    public List<Photo> getPhotosByCheckinId(int checkinId) {
        this.mPhotoModel = new ArrayList<Photo>();
        this.mMedia = Database.mMediaDao.fetchCheckinPhoto(checkinId);
        if (this.mMedia != null && this.mMedia.size() > 0) {
            for (Media item : this.mMedia) {
                Photo photo = new Photo();
                photo.setDbId(item.getDbId());
                photo.setPhoto(item.getLink());
                this.mPhotoModel.add(photo);
            }
        }
        return this.mPhotoModel;
    }

    public List<Photo> getPendingPhotosByReportId(int reportId) {
        this.mPhotoModel = new ArrayList<Photo>();
        this.mMedia = Database.mMediaDao.fetchPendingReportPhoto(reportId);
        if (this.mMedia != null && this.mMedia.size() > 0) {
            for (Media item : this.mMedia) {
                Photo photo = new Photo();
                photo.setDbId(item.getDbId());
                photo.setPhoto(FETCHED + item.getLink());
                this.mPhotoModel.add(photo);
            }
        }
        return this.mPhotoModel;
    }

    public List<Photo> getPendingPhotosByCheckinId(int checkinId) {
        this.mPhotoModel = new ArrayList<Photo>();
        this.mMedia = Database.mMediaDao.fetchPendingCheckinPhoto(checkinId);
        if (this.mMedia != null && this.mMedia.size() > 0) {
            for (Media item : this.mMedia) {
                Photo photo = new Photo();
                photo.setDbId(item.getDbId());
                photo.setPhoto(FETCHED + item.getLink());
                this.mPhotoModel.add(photo);
            }
        }
        return this.mPhotoModel;
    }

    public int totalReportPhoto() {
        if (this.mMedia != null && this.mMedia.size() > 0) {
            return this.mMedia.size();
        }
        return 0;
    }

    public String getImage(Context context, String path) {
        return path;
    }

    @Override
    public boolean save() {
        return false;
    }
}

