/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Report;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ListReportModel
extends Model {
    public List<Report> mReports;
    public List<ListReportModel> reportModel;
    private long id;
    private int reportId;
    private String title;
    private String date;
    private String status;
    private String thumbnail;
    private Drawable arrow;
    private Uri thumbnailUri;
    private String description;
    private String location;
    private String media;
    private String categories;
    private String latitude;
    private String longitude;

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnailUri(Uri uri) {
        this.thumbnailUri = uri;
    }

    public Uri getThumbnailUri() {
        return this.thumbnailUri;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate() {
        return this.date;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setDesc(String description) {
        this.description = description;
    }

    public String getDesc() {
        return this.description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public String getMedia() {
        return this.media;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getCategories() {
        return this.categories;
    }

    public void setArrow(Drawable arrow) {
        this.arrow = arrow;
    }

    public Drawable getArrow() {
        return this.arrow;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public long getId() {
        return this.id;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setReportId(int reportId) {
        this.reportId = reportId;
    }

    public int getReportId() {
        return this.reportId;
    }

    @Override
    public boolean load() {
        this.mReports = Database.mReportDao.fetchAllReports();
        return this.mReports != null;
    }

    @Override
    public boolean save() {
        return false;
    }

    public boolean loadReportById(long id2) {
        this.mReports = Database.mReportDao.fetchReportById(id2);
        return this.mReports != null;
    }

    public boolean loadPendingReports() {
        this.mReports = Database.mReportDao.fetchAllPendingReports();
        return this.mReports != null;
    }

    public boolean loadPendingReportsByCategory(int categoryId) {
        this.mReports = Database.mReportDao.fetchPendingReportByCategoryId(categoryId);
        return this.mReports != null;
    }

    public boolean loadReportByCategory(int categoryId) {
        this.mReports = Database.mReportDao.fetchReportByCategoryId(categoryId);
        return this.mReports != null;
    }

    public List<ListReportModel> getReports(Context context) {
        this.reportModel = new ArrayList<ListReportModel>();
        String d = null;
        if (this.mReports != null && this.mReports.size() > 0) {
            for (Report item : this.mReports) {
                ListReportModel listReportModel = new ListReportModel();
                listReportModel.setId(item.getDbId());
                listReportModel.setReportId(item.getReportId());
                listReportModel.setTitle(Util.capitalizeString(item.getTitle()));
                listReportModel.setDesc(Util.capitalizeString(item.getDescription()));
                listReportModel.setDate(Util.formatDate("yyyy-MM-dd HH:mm:ss", item.getReportDate(), "MMMM dd, yyyy 'at' hh:mm:ss aaa"));
                String status = Util.toInt(item.getVerified()) == 0 ? context.getString(R.string.unverified) : context.getString(R.string.verified);
                listReportModel.setStatus(Util.capitalizeString(status));
                listReportModel.setLocation(Util.capitalizeString(item.getLocationName()));
                listReportModel.setLatitude(item.getLatitude());
                listReportModel.setLongitude(item.getLongitude());
                listReportModel.setArrow(context.getResources().getDrawable(R.drawable.arrow));
                listReportModel.setCategories(item.getCategories());
                listReportModel.setMedia(item.getMedia());
                d = item.getReportId() == 0 ? this.getImage(item.getDbId()) : this.getImage(item.getReportId());
                listReportModel.setThumbnail(d);
                this.reportModel.add(listReportModel);
            }
        }
        return this.reportModel;
    }

    public List<Category> getParentCategories() {
        return Database.mCategoryDao.fetchAllCategoryTitles();
    }

    public List<Category> getAllCategories() {
        return Database.mCategoryDao.fetchAllCategories();
    }

    public List<Category> getChildrenCategories(int parentId) {
        return Database.mCategoryDao.fetchChildrenCategories(parentId);
    }

    public List<Category> getCategoriesByReportId(int reportId) {
        return Database.mCategoryDao.fetchCategoryByReportId(reportId);
    }

    private String getImage(int reportId) {
        List<Media> sMedia = Database.mMediaDao.fetchMedia("media_report_id", reportId, 1, 1);
        if (sMedia != null && sMedia.size() > 0) {
            return sMedia.get(0).getLink();
        }
        return null;
    }

    public boolean deleteAllFetchedReport(int reportId) {
        if (Database.mReportDao.deleteReportById(reportId)) {
            new Util().log("All fetched report deleted");
        }
        if (Database.mReportCategoryDao.deleteReportCategoryByReportId(reportId)) {
            new Util().log("All fetched report categories deleted");
        }
        if (Database.mCategoryDao.deleteAllCategories()) {
            new Util().log("Category deleted");
        }
        if (Database.mMediaDao.deleteReportPhoto(reportId)) {
            new Util().log("Media deleted");
        }
        return true;
    }

    public boolean deleteReport() {
        if (Database.mReportDao.deleteAllReport()) {
            new Util().log("Report deleted");
        }
        if (Database.mReportCategoryDao.deleteAllReportCategory()) {
            new Util().log("Report categories deleted");
        }
        if (Database.mCategoryDao.deleteAllCategories()) {
            new Util().log("Category deleted");
        }
        if (Database.mMediaDao.deleteAllMedia()) {
            new Util().log("Media deleted");
        }
        return true;
    }
}

