/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.models;

import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.models.Model;
import java.util.ArrayList;
import java.util.List;

public class ListReportNewsModel
extends Model {
    private int id;
    private String title;
    private String url;
    private List<Media> mMedia;
    private List<ListReportNewsModel> mNewsModel;

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean load() {
        return false;
    }

    public boolean load(int reportId) {
        this.mMedia = Database.mMediaDao.fetchReportNews(reportId);
        return this.mMedia != null;
    }

    public List<ListReportNewsModel> getNews() {
        this.mNewsModel = new ArrayList<ListReportNewsModel>();
        if (this.mMedia != null && this.mMedia.size() > 0) {
            ListReportNewsModel newsModel = new ListReportNewsModel();
            newsModel.setId(this.mMedia.get(0).getDbId());
            newsModel.setTitle(this.mMedia.get(0).getLink());
            newsModel.setUrl(this.mMedia.get(0).getLink());
            this.mNewsModel.add(newsModel);
        }
        return this.mNewsModel;
    }

    public List<ListReportNewsModel> getNewsByReportId(int reportId) {
        this.mNewsModel = new ArrayList<ListReportNewsModel>();
        this.mMedia = Database.mMediaDao.fetchReportNews(reportId);
        if (this.mMedia != null && this.mMedia.size() > 0) {
            for (Media item : this.mMedia) {
                ListReportNewsModel newsModel = new ListReportNewsModel();
                newsModel.setId(item.getDbId());
                newsModel.setTitle(item.getLink());
                newsModel.setUrl(item.getLink());
                this.mNewsModel.add(newsModel);
            }
        }
        return this.mNewsModel;
    }

    public int totalReportNews() {
        if (this.mMedia != null && this.mMedia.size() > 0) {
            return this.mMedia.size();
        }
        return 0;
    }

    @Override
    public boolean save() {
        return false;
    }
}

