/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.CategoriesApiUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectTimeoutException;

public class CategoriesHttpClient
extends MainHttpClient {
    private ApiUtils apiUtils;

    public CategoriesHttpClient(Context context) {
        super(context);
        this.apiUtils = new ApiUtils(context);
    }

    public int getCategoriesFromWeb() {
        String categoriesResponse = "";
        this.apiUtils.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=categories");
        uriBuilder.append("&resp=json");
        try {
            HttpResponse response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                return 100;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                categoriesResponse = this.GetText(response);
                CategoriesApiUtils categoriesApiUtils = new CategoriesApiUtils(categoriesResponse);
                if (categoriesApiUtils.getCategoriesList()) {
                    Preferences.categoriesResponse = categoriesResponse;
                    return 0;
                }
                return 99;
            }
            return 100;
        }
        catch (SocketTimeoutException e) {
            this.log("SocketTimeoutException e", e);
            return 110;
        }
        catch (ConnectTimeoutException e) {
            this.log("ConnectTimeoutException", (Exception)((Object)e));
            return 110;
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return 111;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return 120;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return 112;
        }
    }
}

