/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import android.text.TextUtils;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.CheckinApiUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class CheckinHttpClient
extends MainHttpClient {
    private static MultipartEntity entity;
    private Context context;
    private ApiUtils apiUtils;

    public CheckinHttpClient(Context context) {
        super(context);
        this.context = context;
        this.apiUtils = new ApiUtils(context);
    }

    public int getAllCheckinFromWeb() {
        String checkins = "";
        this.apiUtils.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=checkin");
        uriBuilder.append("&action=get_ci");
        uriBuilder.append("&sort=desc");
        uriBuilder.append("&sqllimit=" + Preferences.totalReports);
        uriBuilder.append("&resp=json");
        try {
            HttpResponse response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                return 100;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                checkins = this.GetText(response);
                CheckinApiUtils checkinsApiUtils = new CheckinApiUtils(checkins);
                if (checkinsApiUtils.saveCheckins(this.context) && checkinsApiUtils.saveUsers()) {
                    return 0;
                }
                return 99;
            }
            return 100;
        }
        catch (SocketTimeoutException e) {
            this.log("SocketTimeoutException e", e);
            return 110;
        }
        catch (ConnectTimeoutException e) {
            this.log("ConnectTimeoutException", (Exception)((Object)e));
            return 110;
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return 111;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return 120;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return 112;
        }
    }

    public boolean PostFileUpload(String URL2, HashMap<String, String> params) throws IOException {
        this.log("PostFileUpload(): upload file to server.");
        this.apiUtils.updateDomain();
        entity = new MultipartEntity();
        try {
            HttpPost httpost = new HttpPost(URL2);
            if (params != null) {
                File file;
                entity.addPart("task", (ContentBody)new StringBody(params.get("task")));
                entity.addPart("action", (ContentBody)new StringBody(params.get("action")));
                entity.addPart("mobileid", (ContentBody)new StringBody(params.get("mobileid")));
                entity.addPart("message", (ContentBody)new StringBody(params.get("message"), Charset.forName("UTF-8")));
                entity.addPart("lat", (ContentBody)new StringBody(params.get("lat")));
                entity.addPart("lon", (ContentBody)new StringBody(params.get("lon")));
                entity.addPart("firstname", (ContentBody)new StringBody(params.get("firstname"), Charset.forName("UTF-8")));
                entity.addPart("lastname", (ContentBody)new StringBody(params.get("lastname"), Charset.forName("UTF-8")));
                entity.addPart("email", (ContentBody)new StringBody(params.get("email"), Charset.forName("UTF-8")));
                if (params.get("filename") != null && !TextUtils.isEmpty((CharSequence)params.get("filename")) && (file = new File(ImageManager.getPhotoPath(this.context, params.get("filename")))) != null && file.exists()) {
                    entity.addPart("photo", (ContentBody)new FileBody(file));
                }
                httpost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpost.setEntity((HttpEntity)entity);
                HttpResponse response = httpClient.execute((HttpUriRequest)httpost);
                Preferences.httpRunning = false;
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    InputStream serverInput = respEntity.getContent();
                    return serverInput != null;
                }
            }
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return false;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return false;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return false;
        }
        return false;
    }
}

