/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.CommentApiUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class CommentHttpClient
extends MainHttpClient {
    private static MultipartEntity entity;
    private Context context;
    private ApiUtils apiUtils;

    public CommentHttpClient(Context context) {
        super(context);
        this.context = context;
        this.apiUtils = new ApiUtils(context);
    }

    public int getReportComments(int reportid) {
        String comments = "";
        this.apiUtils.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=comments");
        uriBuilder.append("&by=reportid");
        uriBuilder.append("&id=" + reportid);
        uriBuilder.append("&resp=json");
        try {
            HttpResponse response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                return 100;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                comments = this.GetText(response);
                CommentApiUtils commentApiUtils = new CommentApiUtils(comments);
                if (commentApiUtils.saveComments(this.context)) {
                    return 0;
                }
                return 99;
            }
            return 100;
        }
        catch (SocketTimeoutException e) {
            this.log("SocketTimeoutException e", e);
            return 110;
        }
        catch (ConnectTimeoutException e) {
            this.log("ConnectTimeoutException", (Exception)((Object)e));
            return 110;
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return 111;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return 120;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return 112;
        }
    }

    public int getCheckinComments(int checkinid) {
        String comments = "";
        this.apiUtils.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=comments");
        uriBuilder.append("&by=checkinid");
        uriBuilder.append("&id=" + checkinid);
        uriBuilder.append("&resp=json");
        try {
            HttpResponse response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                return 100;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                comments = this.GetText(response);
                CommentApiUtils commentApiUtils = new CommentApiUtils(comments);
                if (commentApiUtils.saveCheckinsComments(this.context)) {
                    return 0;
                }
                return 99;
            }
            return 100;
        }
        catch (SocketTimeoutException e) {
            this.log("SocketTimeoutException e", e);
            return 110;
        }
        catch (ConnectTimeoutException e) {
            this.log("ConnectTimeoutException", (Exception)((Object)e));
            return 110;
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return 111;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return 120;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return 112;
        }
    }

    public boolean PostFileUpload(String URL2, HashMap<String, String> params) throws IOException {
        this.log("PostFileUpload(): upload file to server.");
        this.apiUtils.updateDomain();
        entity = new MultipartEntity();
        try {
            HttpPost httpost = new HttpPost(URL2);
            if (params != null) {
                entity.addPart("task", (ContentBody)new StringBody("comments"));
                entity.addPart("action", (ContentBody)new StringBody("add"));
                entity.addPart("comment_author", (ContentBody)new StringBody(params.get("comment_author")));
                entity.addPart("comment_description", (ContentBody)new StringBody(params.get("comment_description"), Charset.forName("UTF-8")));
                entity.addPart("comment_email", (ContentBody)new StringBody(params.get("comment_email"), Charset.forName("UTF-8")));
                if (params.get("incident_id") != null && Integer.valueOf(params.get("incident_id")) != 0) {
                    entity.addPart("incident_id", (ContentBody)new StringBody(params.get("incident_id")));
                }
                if (params.get("checkin_id") != null && Integer.valueOf(params.get("checkin_id")) != 0) {
                    entity.addPart("checkin_id", (ContentBody)new StringBody(params.get("checkin_id"), Charset.forName("UTF-8")));
                }
                httpost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpost.setEntity((HttpEntity)entity);
                HttpResponse response = httpClient.execute((HttpUriRequest)httpost);
                Preferences.httpRunning = false;
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    InputStream serverInput = respEntity.getContent();
                    return serverInput != null;
                }
            }
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return false;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return false;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return false;
        }
        return false;
    }
}

