/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.net.TrustedSocketFactory;
import com.ushahidi.android.app.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class MainHttpClient {
    protected static DefaultHttpClient httpClient;
    private HttpParams httpParameters;
    private static final String CLASS_TAG;
    private int timeoutConnection = 3000;
    private int timeoutSocket = 3000;
    private static final int IO_BUFFER_SIZE = 512;
    private Context context;

    public MainHttpClient(Context context) {
        this.context = context;
        this.httpParameters = new BasicHttpParams();
        this.httpParameters.setParameter("http.conn-manager.max-total", (Object)1);
        this.httpParameters.setParameter("http.conn-manager.max-per-route", (Object)new ConnPerRouteBean(1));
        this.httpParameters.setParameter("http.protocol.expect-continue", (Object)false);
        HttpProtocolParams.setVersion((HttpParams)this.httpParameters, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)this.httpParameters, (String)"utf8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParameters, (int)this.timeoutConnection);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParameters, (int)this.timeoutSocket);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        try {
            schemeRegistry.register(new Scheme("https", (SocketFactory)new TrustedSocketFactory(Preferences.domain, false), 443));
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(this.httpParameters, schemeRegistry), this.httpParameters);
        httpClient.setParams(this.httpParameters);
    }

    public HttpResponse GetURL(String URL2) throws IOException {
        Preferences.httpRunning = true;
        if (this.isConnected()) {
            try {
                HttpGet httpget = new HttpGet(URL2);
                httpget.addHeader("User-Agent", "Ushahidi-Android/1.0)");
                HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                return response;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public HttpResponse PostURL(String URL2, List<NameValuePair> data, String Referer) throws IOException {
        if (this.isConnected()) {
            HttpPost httpost;
            block9: {
                httpost = new HttpPost(URL2);
                if (Referer.length() > 0) {
                    httpost.addHeader("Referer", Referer);
                }
                if (data == null) break block9;
                try {
                    httpost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                    httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(data, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)httpost);
                Preferences.httpRunning = false;
                return response;
            }
            catch (Exception exception) {
                try {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public HttpResponse PostURL(String URL2, List<NameValuePair> data) throws IOException {
        return this.PostURL(URL2, data, "");
    }

    public static void setHttpHeader(Object header) {
        if (header != null) {
            // empty if block
        }
    }

    public String SendMultiPartData(String URL2, MultipartEntity postData) throws IOException {
        Log.d((String)CLASS_TAG, (String)"PostFileUpload(): upload file to server.");
        try {
            HttpPost httpost = new HttpPost(URL2);
            if (postData != null) {
                Log.i((String)CLASS_TAG, (String)"PostFileUpload(): ");
                httpost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpost.setEntity((HttpEntity)postData);
                HttpResponse response = httpClient.execute((HttpUriRequest)httpost);
                Preferences.httpRunning = false;
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    InputStream serverInput = respEntity.getContent();
                    return this.GetText(serverInput);
                }
            }
        }
        catch (MalformedURLException ex) {
            this.log("MalformedURLException", ex.toString());
            ex.printStackTrace();
            return "";
        }
        catch (Exception ex) {
            return "";
        }
        return "";
    }

    public byte[] fetchImage2(String address) throws MalformedURLException, IOException {
        try {
            HttpResponse response = this.GetURL(address);
            int fileSize = (int)response.getEntity().getContentLength();
            if (fileSize < 0) {
                return null;
            }
            byte[] imageData = new byte[fileSize];
            BufferedInputStream istream = new BufferedInputStream(response.getEntity().getContent(), 512);
            int bytesRead = 0;
            for (int offset = 0; bytesRead != -1 && offset < fileSize; offset += bytesRead) {
                bytesRead = istream.read(imageData, offset, fileSize - offset);
            }
            istream.close();
            return imageData;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] fetchImage(String address) throws MalformedURLException, IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new URL(address).openStream(), 512);
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            out = new BufferedOutputStream(dataStream, 4096);
            this.copy(in, out);
            ((OutputStream)out).flush();
            this.closeStream(in);
            this.closeStream(out);
            byte[] byArray = dataStream.toByteArray();
            this.closeStream(in);
            this.closeStream(out);
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            this.closeStream(in);
            this.closeStream(out);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] b = new byte[4096];
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.e((String)"IO", (String)"Could not close stream", (Throwable)e);
            }
        }
    }

    public String GetText(HttpResponse response) {
        String text = "";
        try {
            text = this.GetText(response.getEntity().getContent());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return text;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetText(InputStream in) {
        String text = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"), 1024);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            if (reader != null) {
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
                text = sb.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string2 = text;
            return string2;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return text;
            }
        }
        return text;
    }

    public boolean isConnected() {
        ConnectivityManager connectivity = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.isAvailable();
    }

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }

    static {
        CLASS_TAG = MainHttpClient.class.getSimpleName();
    }
}

