/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import android.location.Location;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Map;
import com.ushahidi.android.app.net.MainHttpClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MapsHttpClient
extends MainHttpClient {
    private static final String MAP_SEARCH_URL = "http://tracker.ushahidi.com/list/";
    private String mDistance;
    private double lat;
    private double lon;
    private JSONObject jsonObject;
    private boolean processingResult;
    private String mapJson = "";
    private List<Map> mMap;

    public MapsHttpClient(Context context) {
        super(context);
    }

    public boolean fetchMaps(String distance, Location location) {
        this.mDistance = distance;
        if (location != null) {
            this.processingResult = true;
            this.lat = location.getLatitude();
            this.lon = location.getLongitude();
            this.mapJson = this.getMapsFromOnline();
            if (this.mapJson != null) {
                try {
                    this.jsonObject = new JSONObject(this.mapJson);
                    this.mMap = this.retrieveMapJson();
                    if (this.mMap != null) {
                        Database.mMapDao.deleteAllAutoMap();
                        Database.mMapDao.addMaps(this.mMap);
                        return true;
                    }
                }
                catch (JSONException e) {
                    this.processingResult = false;
                }
            }
        }
        return false;
    }

    public String getMapsFromOnline() {
        StringBuilder fullUrl = new StringBuilder(MAP_SEARCH_URL);
        fullUrl.append("?return_vars=name,latitude,longitude,description,url,category_id,discovery_date,id");
        fullUrl.append("&units=km");
        fullUrl.append("&distance=" + this.mDistance);
        fullUrl.append("&lat=" + String.valueOf(this.lat));
        fullUrl.append("&lon=" + String.valueOf(this.lon));
        try {
            HttpResponse response = this.GetURL(fullUrl.toString());
            if (response == null) {
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return this.GetText(response);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public List<Map> retrieveMapJson() {
        JSONArray names = this.jsonObject.names();
        ArrayList<Map> mapsList = new ArrayList<Map>();
        if (this.processingResult) {
            for (int i = 0; i < names.length(); ++i) {
                Map mapModel = new Map();
                try {
                    mapModel.setMapId(this.jsonObject.getJSONObject(names.getString(i)).getInt("id"));
                    mapModel.setDate(this.jsonObject.getJSONObject(names.getString(i)).getString("discovery_date"));
                    mapModel.setActive("0");
                    mapModel.setLat(this.jsonObject.getJSONObject(names.getString(i)).getString("latitude"));
                    mapModel.setLon(this.jsonObject.getJSONObject(names.getString(i)).getString("longitude"));
                    mapModel.setName(this.jsonObject.getJSONObject(names.getString(i)).getString("name"));
                    mapModel.setUrl(this.jsonObject.getJSONObject(names.getString(i)).getString("url"));
                    if (this.jsonObject.getJSONObject(names.getString(i)).getString("description").equals("")) {
                        mapModel.setDesc(this.jsonObject.getJSONObject(names.getString(i)).getString("name"));
                    } else {
                        mapModel.setDesc(this.jsonObject.getJSONObject(names.getString(i)).getString("description"));
                    }
                    mapModel.setCatId(this.jsonObject.getJSONObject(names.getString(i)).getInt("category_id"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    this.processingResult = false;
                    return null;
                }
                mapsList.add(mapModel);
            }
            return mapsList;
        }
        return null;
    }
}

