/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.content.Context;
import android.text.TextUtils;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.ReportsApiUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class ReportsHttpClient
extends MainHttpClient {
    private static MultipartEntity entity;
    private Context context;
    private ApiUtils apiUtils;

    public ReportsHttpClient(Context context) {
        super(context);
        this.context = context;
        this.apiUtils = new ApiUtils(context);
    }

    public int getAllReportFromWeb() {
        String incidents = "";
        this.apiUtils.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=incidents");
        uriBuilder.append("&by=all");
        uriBuilder.append("&limit=" + Preferences.totalReports);
        uriBuilder.append("&resp=json");
        try {
            HttpResponse response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                return 100;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                incidents = this.GetText(response);
                ReportsApiUtils reportsApiUtils = new ReportsApiUtils(incidents);
                if (reportsApiUtils.saveReports(this.context)) {
                    return 0;
                }
                return 99;
            }
            return 100;
        }
        catch (SocketTimeoutException e) {
            this.log("SocketTimeoutException e", e);
            return 110;
        }
        catch (ConnectTimeoutException e) {
            this.log("ConnectTimeoutException", (Exception)((Object)e));
            return 110;
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return 111;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return 120;
        }
        catch (IOException e) {
            this.log("IOException", e);
            return 112;
        }
    }

    public boolean PostFileUpload(String URL2, HashMap<String, String> params) throws IOException {
        this.log("PostFileUpload(): upload file to server.");
        this.apiUtils.updateDomain();
        entity = new MultipartEntity();
        try {
            HttpPost httpost = new HttpPost(URL2);
            if (params != null) {
                for (Map.Entry<String, String> en : params.entrySet()) {
                    String key = en.getKey();
                    if (key == null || "".equals(key)) continue;
                    String val = en.getValue();
                    if (!"filename".equals(key)) {
                        entity.addPart(key, (ContentBody)new StringBody(val, Charset.forName("UTF-8")));
                        continue;
                    }
                    if (TextUtils.isEmpty((CharSequence)val)) continue;
                    String[] filenames = val.split(",");
                    this.log("filenames " + ImageManager.getPhotoPath(this.context, filenames[0]));
                    for (int i = 0; i < filenames.length; ++i) {
                        File file;
                        if (ImageManager.getPhotoPath(this.context, filenames[i]) == null || !(file = new File(ImageManager.getPhotoPath(this.context, filenames[i]))).exists()) continue;
                        entity.addPart("incident_photo[]", (ContentBody)new FileBody(file));
                    }
                }
                httpost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpost.setEntity((HttpEntity)entity);
                HttpResponse response = httpClient.execute((HttpUriRequest)httpost);
                Preferences.httpRunning = false;
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    InputStream serverInput = respEntity.getContent();
                    int status = ApiUtils.extractPayloadJSON(this.GetText(serverInput));
                    return status == 0;
                }
            }
        }
        catch (MalformedURLException ex) {
            this.log("PostFileUpload(): MalformedURLException", ex);
            return false;
        }
        catch (IllegalArgumentException ex) {
            this.log("IllegalArgumentException", ex);
            return false;
        }
        catch (ConnectTimeoutException ex) {
            this.log("ConnectionTimeoutException");
            return false;
        }
        catch (SocketTimeoutException ex) {
            this.log("SocketTimeoutException");
        }
        catch (IOException e) {
            this.log("IOException", e);
            return false;
        }
        return false;
    }
}

