/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.net;

import android.app.Application;
import android.util.Log;
import com.ushahidi.android.app.MainApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class TrustManagerFactory {
    private static final String LOG_TAG = "TrustManagerFactory";
    private static X509TrustManager defaultTrustManager;
    private static X509TrustManager unsecureTrustManager;
    private static X509TrustManager localTrustManager;
    private static X509Certificate[] lastCertChain;
    private static File keyStoreFile;
    private static KeyStore keyStore;

    private TrustManagerFactory() {
    }

    public static X509TrustManager get(String host, boolean secure) {
        return secure ? SecureX509TrustManager.getInstance(host) : unsecureTrustManager;
    }

    public static KeyStore getKeyStore() {
        return keyStore;
    }

    public static void setLastCertChain(X509Certificate[] chain) {
        lastCertChain = chain;
    }

    public static X509Certificate[] getLastCertChain() {
        return lastCertChain;
    }

    public static void addCertificateChain(String alias, X509Certificate[] chain) throws CertificateException {
        try {
            javax.net.ssl.TrustManagerFactory tmf = javax.net.ssl.TrustManagerFactory.getInstance("X509");
            for (X509Certificate element : chain) {
                keyStore.setCertificateEntry(element.getSubjectDN().toString(), element);
            }
            tmf.init(keyStore);
            TrustManager[] tms = tmf.getTrustManagers();
            if (tms != null) {
                for (TrustManager tm : tms) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    localTrustManager = (X509TrustManager)tm;
                    break;
                }
            }
            FileOutputStream keyStoreStream = null;
            try {
                keyStoreStream = new FileOutputStream(keyStoreFile);
                keyStore.store(keyStoreStream, "".toCharArray());
            }
            catch (FileNotFoundException e) {
                throw new CertificateException("Unable to write KeyStore: " + e.getMessage());
            }
            catch (CertificateException e) {
                throw new CertificateException("Unable to write KeyStore: " + e.getMessage());
            }
            catch (IOException e) {
                throw new CertificateException("Unable to write KeyStore: " + e.getMessage());
            }
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)LOG_TAG, (String)"Unable to get X509 Trust Manager ", (Throwable)e);
        }
        catch (KeyStoreException e) {
            Log.e((String)LOG_TAG, (String)"Key Store exception while initializing TrustManagerFactory ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block13: {
            lastCertChain = null;
            FileInputStream fis = null;
            try {
                javax.net.ssl.TrustManagerFactory tmf = javax.net.ssl.TrustManagerFactory.getInstance("X509");
                Application app = MainApplication.app;
                keyStoreFile = new File(app.getDir("KeyStore", 0) + File.separator + "KeyStore.bks");
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try {
                    fis = new FileInputStream(keyStoreFile);
                }
                catch (FileNotFoundException e1) {
                    fis = null;
                }
                try {
                    keyStore.load(fis, "".toCharArray());
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)"KeyStore IOException while initializing TrustManagerFactory ", (Throwable)e);
                    keyStore = null;
                }
                catch (CertificateException e) {
                    Log.e((String)LOG_TAG, (String)"KeyStore CertificateException while initializing TrustManagerFactory ", (Throwable)e);
                    keyStore = null;
                }
                Log.i((String)LOG_TAG, (String)("keyStore: " + keyStore.toString()));
                tmf.init(keyStore);
                TrustManager[] tms = tmf.getTrustManagers();
                if (tms != null) {
                    for (TrustManager tm : tms) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        localTrustManager = (X509TrustManager)tm;
                        break;
                    }
                }
                tmf = javax.net.ssl.TrustManagerFactory.getInstance("X509");
                tmf.init((KeyStore)null);
                tms = tmf.getTrustManagers();
                if (tms == null) break block13;
                for (TrustManager tm : tms) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    defaultTrustManager = (X509TrustManager)tm;
                    break;
                }
            }
            catch (NoSuchAlgorithmException e) {
                Log.e((String)LOG_TAG, (String)"Unable to get X509 Trust Manager ", (Throwable)e);
            }
            catch (KeyStoreException e) {
                Log.e((String)LOG_TAG, (String)"Key Store exception while initializing TrustManagerFactory ", (Throwable)e);
            }
        }
        unsecureTrustManager = new SimpleX509TrustManager();
    }

    private static class SecureX509TrustManager
    implements X509TrustManager {
        private static final Map<String, SecureX509TrustManager> mTrustManager = new HashMap<String, SecureX509TrustManager>();
        private final String mHost;

        private SecureX509TrustManager(String host) {
            this.mHost = host;
        }

        public static synchronized X509TrustManager getInstance(String host) {
            SecureX509TrustManager trustManager;
            if (mTrustManager.containsKey(host)) {
                trustManager = mTrustManager.get(host);
            } else {
                trustManager = new SecureX509TrustManager(host);
                mTrustManager.put(host, trustManager);
            }
            return trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            defaultTrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            TrustManagerFactory.setLastCertChain(chain);
            try {
                defaultTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                localTrustManager.checkServerTrusted(new X509Certificate[]{chain[0]}, authType);
            }
            try {
                String dn = chain[0].getSubjectDN().toString();
                if (dn != null && dn.equalsIgnoreCase(keyStore.getCertificateAlias(chain[0]))) {
                    return;
                }
            }
            catch (KeyStoreException e) {
                throw new CertificateException("Certificate cannot be verified; KeyStore Exception: " + e);
            }
            throw new CertificateException("Certificate domain name does not match " + this.mHost);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return defaultTrustManager.getAcceptedIssuers();
        }
    }

    private static class SimpleX509TrustManager
    implements X509TrustManager {
        private SimpleX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

