/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.opengeosms;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.SmsManager;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Semaphore;

public class OpenGeoSMSSender {
    private Context mContext;

    public OpenGeoSMSSender(Context c) {
        this.mContext = c;
    }

    public static String createReport(String url, ListReportModel report) {
        String date = Util.formatDate("MMMM dd, yyyy 'at' hh:mm:ss aaa", report.getDate(), "MM/dd/yyyy hh:mm a", null, Locale.US).toLowerCase();
        String payload = String.format("%s#%s@%s\n%s\n%s", report.getTitle(), report.getCategories(), date, report.getLocation(), report.getDesc());
        return OpenGeoSMSSender.composeOpenGeoSMS(url, report.getLatitude(), report.getLongitude(), payload);
    }

    public boolean sendReport(String address, String url, ListReportModel report) {
        String smsMsg = OpenGeoSMSSender.createReport(url, report);
        SmsManager smsManager = SmsManager.getDefault();
        ArrayList msgs = smsManager.divideMessage(smsMsg);
        ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>();
        String action = OpenGeoSMSSender.class.getCanonicalName() + UUID.randomUUID().toString();
        Intent intent = new Intent(action);
        for (int i = 0; i < msgs.size(); ++i) {
            pendingIntents.add(PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0));
        }
        Receiver r = new Receiver();
        this.mContext.registerReceiver((BroadcastReceiver)r, new IntentFilter(action));
        smsManager.sendMultipartTextMessage(address, null, msgs, pendingIntents, null);
        return r.waitForResult(pendingIntents);
    }

    private static String composeOpenGeoSMS(String url, String lat, String lng, String payload) {
        String firstParam = "q=";
        String postfix = "GeoSMS";
        return url + "?" + firstParam + lat + "," + lng + "&" + "GeoSMS" + "\n" + payload;
    }

    private class Receiver
    extends BroadcastReceiver {
        private Semaphore mSem = new Semaphore(0);
        private boolean mRecvRetVal = false;
        private List<PendingIntent> mPendingIntents;

        private Receiver() {
        }

        public boolean waitForResult(List<PendingIntent> pIntents) {
            this.mPendingIntents = pIntents;
            this.mSem.acquireUninterruptibly();
            return this.mRecvRetVal;
        }

        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() != -1) {
                this.mRecvRetVal = false;
                context.unregisterReceiver((BroadcastReceiver)this);
                this.mSem.release();
                return;
            }
            this.mPendingIntents.remove(this.mPendingIntents.size() - 1);
            if (this.mPendingIntents.isEmpty()) {
                this.mRecvRetVal = true;
                context.unregisterReceiver((BroadcastReceiver)this);
                this.mSem.release();
            }
        }
    }
}

