/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.services;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.adapters.ListFetchedCheckinAdapter;
import com.ushahidi.android.app.adapters.ListPendingCheckinAdapter;
import com.ushahidi.android.app.adapters.UploadPhotoAdapter;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.AddCheckinModel;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.net.CheckinHttpClient;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FetchCheckins
extends SyncServices {
    private static String CLASS_TAG = FetchCheckins.class.getSimpleName();
    private Intent statusIntent = new Intent(FETCH_CHECKIN_SERVICES_ACTION);
    private int status = 4;
    private ListFetchedCheckinAdapter fetchedAdapter;
    private ListPendingCheckinAdapter pendingAdapter;

    public FetchCheckins() {
        super(CLASS_TAG);
    }

    private boolean uploadPendingCheckin() {
        Iterator<ListCheckinModel> iterator;
        this.fetchedAdapter = new ListFetchedCheckinAdapter((Context)this);
        this.pendingAdapter = new ListPendingCheckinAdapter((Context)this);
        List<ListCheckinModel> items = this.pendingAdapter.pendingCheckin();
        StringBuilder urlBuilder = new StringBuilder(Preferences.domain);
        urlBuilder.append("/api");
        if (items != null && (iterator = items.iterator()).hasNext()) {
            ListCheckinModel checkin = iterator.next();
            HashMap<String, String> mParams = new HashMap<String, String>();
            mParams.put("task", "checkin");
            mParams.put("action", "ci");
            mParams.put("mobileid", Util.IMEI((Context)this));
            mParams.put("lat", checkin.getLocationLatitude());
            mParams.put("lon", checkin.getLocationLongitude());
            mParams.put("message", checkin.getMessage());
            mParams.put("firstname", Preferences.firstname);
            mParams.put("lastname", Preferences.lastname);
            mParams.put("email", Preferences.email);
            String photo = new UploadPhotoAdapter((Context)this).pendingPhotos(checkin.getCheckinId());
            if (!TextUtils.isEmpty((CharSequence)photo)) {
                mParams.put("filename", photo);
            }
            try {
                if (new CheckinHttpClient((Context)this).PostFileUpload(urlBuilder.toString(), mParams)) {
                    this.deletePendingCheckin(checkin.getDbId());
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private void deleteFetchedCheckin() {
        this.fetchedAdapter = new ListFetchedCheckinAdapter((Context)this);
        this.pendingAdapter = new ListPendingCheckinAdapter((Context)this);
        List<ListCheckinModel> items = this.fetchedAdapter.fetchedCheckins();
        for (ListCheckinModel checkin : items) {
            new ListCheckinModel().deleteAllFetchedCheckin(checkin.getCheckinId());
        }
        ImageManager.deleteImages((Context)this);
    }

    private void deletePendingCheckin(int checkinId) {
        AddCheckinModel model = new AddCheckinModel();
        UploadPhotoAdapter pendingPhoto = new UploadPhotoAdapter((Context)this);
        if (checkinId > 0 && model.deleteCheckin(checkinId)) {
            for (int i = 0; i < pendingPhoto.getCount(); ++i) {
                ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)pendingPhoto.getItem(i)).getPhoto());
            }
        }
    }

    @Override
    protected void executeTask(Intent intent) {
        this.fetchedAdapter = new ListFetchedCheckinAdapter((Context)this);
        this.pendingAdapter = new ListPendingCheckinAdapter((Context)this);
        new Util().log("executeTask() executing this task");
        if (new ApiUtils((Context)this).isConnected()) {
            if (!this.pendingAdapter.isEmpty()) {
                this.uploadPendingCheckin();
            }
            this.deleteFetchedCheckin();
            this.status = new CheckinHttpClient((Context)this).getAllCheckinFromWeb();
        }
        this.statusIntent.putExtra("status", this.status);
        this.sendBroadcast(this.statusIntent);
    }
}

