/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.services;

import android.content.Context;
import android.content.Intent;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.net.CategoriesHttpClient;
import com.ushahidi.android.app.net.CheckinHttpClient;
import com.ushahidi.android.app.net.ReportsHttpClient;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.Util;

public class FetchReports
extends SyncServices {
    private static String CLASS_TAG = FetchReports.class.getSimpleName();
    private Intent statusIntent = new Intent(SYNC_SERVICES_ACTION);
    private int status = 113;

    public FetchReports() {
        super(CLASS_TAG);
    }

    public void clearCachedData() {
        new ListReportModel().deleteReport();
        new ListCheckinModel().deleteCheckin();
        new ListCommentModel().deleteComments();
        ImageManager.deleteImages((Context)this);
        ImageManager.deletePendingImages((Context)this);
        Database.mOpenGeoSmsDao.deleteReports();
    }

    @Override
    protected void executeTask(Intent intent) {
        new Util().log("executeTask() executing this task");
        this.clearCachedData();
        if (!new ApiUtils((Context)this).isCheckinEnabled()) {
            new CategoriesHttpClient((Context)this).getCategoriesFromWeb();
            this.status = new ReportsHttpClient((Context)this).getAllReportFromWeb();
        } else {
            this.status = new CheckinHttpClient((Context)this).getAllCheckinFromWeb();
        }
        this.statusIntent.putExtra("status", this.status);
        this.sendBroadcast(this.statusIntent);
    }
}

