/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.services;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.wifi.WifiManager;
import android.os.PowerManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.services.ConnectivityChangedReceiver;
import com.ushahidi.android.app.util.Util;

public abstract class SyncServices
extends IntentService {
    public static String SYNC_SERVICES_ACTION = "com.ushahidi.android.app.services.sync";
    public static String UPLOAD_CHECKIN_SERVICES_ACTION = "com.ushahidi.android.app.services.uploadcheckin";
    public static String FETCH_CHECKIN_SERVICES_ACTION = "com.ushahidi.android.app.services.fetchcheckin";
    public static String FETCH_CHECKIN_COMMENTS_SERVICES_ACTION = "com.ushahidi.android.app.services.fetchcheckincomments";
    public static String FETCH_REPORT_COMMENTS_SERVICES_ACTION = "com.ushahidi.android.app.services.fetchreportcomments";
    public static String UPLOAD_COMMENT_SERVICES_ACTION = "com.ushahidi.android.app.services.uploadcomment";
    protected static String CLASS_TAG = SyncServices.class.getSimpleName();
    protected static PowerManager.WakeLock mStartingService = null;
    protected static WifiManager.WifiLock wifilock = null;
    protected NotificationManager notificationManager;
    protected static final Object mStartingServiceSync = new Object();

    public SyncServices(String name) {
        super(name);
    }

    private static synchronized PowerManager.WakeLock getPhoneWakeLock(Context context) {
        if (mStartingService == null) {
            PowerManager mgr = (PowerManager)context.getSystemService("power");
            mStartingService = mgr.newWakeLock(1, CLASS_TAG);
        }
        return mStartingService;
    }

    private static synchronized WifiManager.WifiLock getPhoneWifiLock(Context context) {
        if (wifilock == null) {
            WifiManager manager = (WifiManager)context.getSystemService("wifi");
            wifilock = manager.createWifiLock(1, CLASS_TAG);
        }
        return wifilock;
    }

    protected static void sendWakefulTask(Context context, Intent i) {
        SyncServices.getPhoneWakeLock(context.getApplicationContext()).acquire();
        SyncServices.getPhoneWifiLock(context.getApplicationContext()).acquire();
        context.startService(i);
    }

    public static void sendWakefulTask(Context context, Class<?> classService) {
        SyncServices.sendWakefulTask(context, new Intent(context, classService));
    }

    protected abstract void executeTask(Intent var1);

    public void onCreate() {
        super.onCreate();
        Preferences.loadSettings((Context)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        new Util().log("onHandleIntent(): running service");
        try {
            boolean isConnected = Util.isConnected((Context)this);
            if (!isConnected) {
                PackageManager pm = this.getPackageManager();
                ComponentName connectivityReceiver = new ComponentName((Context)this, ConnectivityChangedReceiver.class);
                pm.setComponentEnabledSetting(connectivityReceiver, 1, 1);
            } else {
                this.executeTask(intent);
            }
        }
        finally {
            if (SyncServices.getPhoneWakeLock(this.getApplicationContext()).isHeld() && SyncServices.getPhoneWakeLock(this.getApplicationContext()) != null) {
                SyncServices.getPhoneWakeLock(this.getApplicationContext()).release();
            }
            if (SyncServices.getPhoneWifiLock(this.getApplicationContext()).isHeld() && SyncServices.getPhoneWifiLock(this.getApplicationContext()) != null) {
                SyncServices.getPhoneWifiLock(this.getApplicationContext()).release();
            }
        }
    }

    public void onDestroy() {
        if (SyncServices.getPhoneWifiLock(this.getApplicationContext()).isHeld() && SyncServices.getPhoneWifiLock(this.getApplicationContext()) != null) {
            SyncServices.getPhoneWifiLock(this.getApplicationContext()).release();
        }
        if (SyncServices.getPhoneWakeLock(this.getApplicationContext()).isHeld() && SyncServices.getPhoneWakeLock(this.getApplicationContext()) != null) {
            SyncServices.getPhoneWakeLock(this.getApplicationContext()).release();
        }
    }
}

