/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.services;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.adapters.ListFetchedCheckinAdapter;
import com.ushahidi.android.app.adapters.UploadPhotoAdapter;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.AddCheckinModel;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.net.CheckinHttpClient;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.util.PhotoUtils;
import com.ushahidi.android.app.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UploadCheckins
extends SyncServices {
    private static String CLASS_TAG = UploadCheckins.class.getSimpleName();
    private Intent statusIntent = new Intent(UPLOAD_CHECKIN_SERVICES_ACTION);
    private int status = 113;
    private UploadPhotoAdapter pendingPhoto;
    private AddCheckinModel model = new AddCheckinModel();

    public UploadCheckins() {
        super(CLASS_TAG);
    }

    private int addCheckins(Bundle bundle) {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        if (bundle != null) {
            int id2 = bundle.getInt("id");
            Checkin checkin = new Checkin();
            checkin.setPending(1);
            checkin.setMessage(bundle.getString("message"));
            checkin.setLocationLatitude(bundle.getString("latitude"));
            checkin.setLocationLongitude(bundle.getString("longitude"));
            checkin.setDate(bundle.getString("date"));
            checkin.setLocationName(bundle.getString("location"));
            if (!this.uploadPendingCheckin(bundle)) {
                if (id2 == 0) {
                    if (this.model.addPendingCheckin(checkin, pendingPhotos)) {
                        ImageManager.movePendingPhotos((Context)this);
                        return 1;
                    }
                } else {
                    ArrayList<Photo> photos = new ArrayList<Photo>();
                    for (int i = 0; i < this.pendingPhoto.getCount(); ++i) {
                        photos.add((Photo)this.pendingPhoto.getItem(i));
                    }
                    if (this.model.updatePendingCheckin(id2, checkin, photos)) {
                        ImageManager.movePendingPhotos((Context)this);
                        return 2;
                    }
                }
                return 3;
            }
        }
        return 0;
    }

    private boolean uploadPendingCheckin(Bundle bundle) {
        StringBuilder urlBuilder = new StringBuilder(Preferences.domain);
        urlBuilder.append("/api");
        HashMap<String, String> mParams = new HashMap<String, String>();
        this.pendingPhoto = new UploadPhotoAdapter((Context)this);
        if (bundle != null) {
            String photo = new UploadPhotoAdapter((Context)this).pendingCheckinPhotos();
            mParams.put("task", "checkin");
            mParams.put("action", "ci");
            mParams.put("mobileid", Util.IMEI((Context)this));
            mParams.put("lat", bundle.getString("latitude"));
            mParams.put("lon", bundle.getString("longitude"));
            mParams.put("message", bundle.getString("message"));
            mParams.put("firstname", bundle.getString("firstname"));
            mParams.put("lastname", bundle.getString("lastname"));
            mParams.put("email", bundle.getString("email"));
            if (!TextUtils.isEmpty((CharSequence)photo)) {
                mParams.put("filename", photo);
            }
            try {
                if (new CheckinHttpClient((Context)this).PostFileUpload(urlBuilder.toString(), mParams)) {
                    this.model.deleteCheckin(0);
                    for (int i = 0; i < this.pendingPhoto.getCount(); ++i) {
                        ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(i)).getPhoto());
                    }
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private void deleteFetchedCheckin() {
        List<ListCheckinModel> items = new ListFetchedCheckinAdapter((Context)this).fetchedCheckins();
        for (ListCheckinModel checkin : items) {
            new ListCheckinModel().deleteAllFetchedCheckin(checkin.getCheckinId());
        }
        ImageManager.deleteImages((Context)this);
    }

    @Override
    protected void executeTask(Intent intent) {
        new Util().log("executeTask() executing this task");
        if (intent != null) {
            Bundle bundle = intent.getExtras();
            this.status = this.addCheckins(bundle);
            if (this.status < 3) {
                this.deleteFetchedCheckin();
                new CheckinHttpClient((Context)this).getAllCheckinFromWeb();
            }
        }
        this.statusIntent.putExtra("status", this.status);
        this.sendBroadcast(this.statusIntent);
    }
}

