/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.tasks;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.os.AsyncTask;
import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class GeocoderTask
extends AsyncTask<Double, Void, String> {
    protected final Context context;
    protected boolean executing;

    public GeocoderTask(Context context) {
        this.context = context;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.executing = true;
    }

    protected String doInBackground(Double ... location) {
        Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)String.format("doInBackground %s", Arrays.toString((Object[])location)));
        Geocoder geoCoder = new Geocoder(this.context);
        try {
            List addresses = geoCoder.getFromLocation(location[0].doubleValue(), location[1].doubleValue(), 1);
            StringBuilder addressString = new StringBuilder();
            if (addresses != null && addresses.size() > 0) {
                Address address = (Address)addresses.get(0);
                if (address.getFeatureName() != null) {
                    addressString.append(address.getFeatureName());
                }
                if (address.getThoroughfare() != null) {
                    if (addressString.length() > 0) {
                        addressString.append(", ");
                    }
                    addressString.append(address.getThoroughfare());
                }
                if (address.getSubAdminArea() != null) {
                    if (addressString.length() > 0) {
                        addressString.append(", ");
                    }
                    addressString.append(address.getSubAdminArea());
                }
                if (address.getLocality() != null && !address.getLocality().equalsIgnoreCase(address.getSubAdminArea())) {
                    if (addressString.length() > 0) {
                        addressString.append(", ");
                    }
                    addressString.append(address.getLocality());
                }
                if (address.getCountryName() != null) {
                    if (addressString.length() > 0) {
                        addressString.append(", ");
                    }
                    addressString.append(address.getCountryName());
                }
            }
            return addressString.toString();
        }
        catch (IOException ioe) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"IOException", (Throwable)ioe);
        }
        catch (IllegalArgumentException ioe) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"IllegalArgumentException", (Throwable)ioe);
        }
        return null;
    }

    protected void onPostExecute(String result) {
        Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)String.format("onPostExecute %s", result));
        this.executing = false;
    }

    public boolean isExecuting() {
        return this.executing;
    }
}

