/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.tasks;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.tasks.ProgressCallback;
import com.ushahidi.android.app.tasks.Task;

public abstract class ProgressTask
extends Task<String, String, Boolean> {
    protected final ProgressDialog dialog;
    protected ProgressCallback callback;

    protected ProgressTask(Activity activity) {
        this(activity, R.string.loading_);
    }

    protected ProgressTask(Activity activity, int message) {
        super(activity);
        this.dialog = new ProgressDialog((Context)activity);
        this.dialog.setCancelable(true);
        this.dialog.setIndeterminate(true);
        this.dialog.setMessage((CharSequence)activity.getString(message));
    }

    public void register(ProgressCallback callback) {
        this.callback = callback;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.dialog.show();
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        if (values != null && values.length > 0) {
            this.dialog.setMessage((CharSequence)values[0]);
        }
        if (!this.dialog.isShowing()) {
            this.dialog.show();
        }
    }

    @Override
    protected void onPostExecute(Boolean success) {
        super.onPostExecute(success);
        this.dialog.dismiss();
        if (this.callback != null) {
            this.callback.execute();
        }
    }
}

