/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ushahidi.android.app.R;

public class PullToRefreshListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final int TAP_TO_REFRESH = 1;
    private static final int PULL_TO_REFRESH = 2;
    private static final int RELEASE_TO_REFRESH = 3;
    private static final int REFRESHING = 4;
    private static final String TAG = "PullToRefreshListView";
    private OnRefreshListener mOnRefreshListener;
    private AbsListView.OnScrollListener mOnScrollListener;
    private LayoutInflater mInflater;
    private RelativeLayout mRefreshView;
    private TextView mRefreshViewText;
    private ImageView mRefreshViewImage;
    private ProgressBar mRefreshViewProgress;
    private TextView mRefreshViewLastUpdated;
    private int mCurrentScrollState;
    private int mRefreshState;
    private RotateAnimation mFlipAnimation;
    private RotateAnimation mReverseFlipAnimation;
    private int mRefreshViewHeight;
    private int mRefreshOriginalTopPadding;
    private int mLastMotionY;
    private boolean mBounceHack;

    public PullToRefreshListView(Context context) {
        super(context);
        this.init(context);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mFlipAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mFlipAnimation.setDuration(250L);
        this.mFlipAnimation.setFillAfter(true);
        this.mReverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mReverseFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mReverseFlipAnimation.setDuration(250L);
        this.mReverseFlipAnimation.setFillAfter(true);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mRefreshView = (RelativeLayout)this.mInflater.inflate(R.layout.list_header, (ViewGroup)this, false);
        this.mRefreshViewText = (TextView)this.mRefreshView.findViewById(R.id.pull_to_refresh_text);
        this.mRefreshViewImage = (ImageView)this.mRefreshView.findViewById(R.id.pull_to_refresh_image);
        this.mRefreshViewProgress = (ProgressBar)this.mRefreshView.findViewById(R.id.pull_to_refresh_progress);
        this.mRefreshViewLastUpdated = (TextView)this.mRefreshView.findViewById(R.id.pull_to_refresh_updated_at);
        this.mRefreshViewImage.setMinimumHeight(50);
        this.mRefreshView.setOnClickListener((View.OnClickListener)new OnClickRefreshListener());
        this.mRefreshOriginalTopPadding = this.mRefreshView.getPaddingTop();
        this.mRefreshState = 1;
        this.addHeaderView((View)this.mRefreshView);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.measureView((View)this.mRefreshView);
        this.mRefreshViewHeight = this.mRefreshView.getMeasuredHeight();
    }

    protected void onAttachedToWindow() {
        this.setSelection(1);
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        this.setSelection(1);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public void setLastUpdated(CharSequence lastUpdated) {
        if (lastUpdated != null) {
            this.mRefreshViewLastUpdated.setVisibility(0);
            this.mRefreshViewLastUpdated.setText(lastUpdated);
        } else {
            this.mRefreshViewLastUpdated.setVisibility(8);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int y = (int)event.getY();
        this.mBounceHack = false;
        switch (event.getAction()) {
            case 1: {
                if (!this.isVerticalScrollBarEnabled()) {
                    this.setVerticalScrollBarEnabled(true);
                }
                if (this.getFirstVisiblePosition() != 0 || this.mRefreshState == 4) break;
                if ((this.mRefreshView.getBottom() >= this.mRefreshViewHeight || this.mRefreshView.getTop() >= 0) && this.mRefreshState == 3) {
                    this.mRefreshState = 4;
                    this.prepareForRefresh();
                    this.onRefresh();
                    break;
                }
                if (this.mRefreshView.getBottom() >= this.mRefreshViewHeight && this.mRefreshView.getTop() > 0) break;
                this.resetHeader();
                this.setSelection(1);
                break;
            }
            case 0: {
                this.mLastMotionY = y;
                break;
            }
            case 2: {
                this.applyHeaderPadding(event);
            }
        }
        return super.onTouchEvent(event);
    }

    private void applyHeaderPadding(MotionEvent ev) {
        int pointerCount = ev.getHistorySize();
        for (int p = 0; p < pointerCount; ++p) {
            if (this.mRefreshState != 3) continue;
            if (this.isVerticalFadingEdgeEnabled()) {
                this.setVerticalScrollBarEnabled(false);
            }
            int historicalY = (int)ev.getHistoricalY(p);
            int topPadding = (int)((double)(historicalY - this.mLastMotionY - this.mRefreshViewHeight) / 1.7);
            this.mRefreshView.setPadding(this.mRefreshView.getPaddingLeft(), topPadding, this.mRefreshView.getPaddingRight(), this.mRefreshView.getPaddingBottom());
        }
    }

    private void resetHeaderPadding() {
        this.mRefreshView.setPadding(this.mRefreshView.getPaddingLeft(), this.mRefreshOriginalTopPadding, this.mRefreshView.getPaddingRight(), this.mRefreshView.getPaddingBottom());
    }

    private void resetHeader() {
        if (this.mRefreshState != 1) {
            this.mRefreshState = 1;
            this.resetHeaderPadding();
            this.mRefreshViewText.setText(R.string.pull_to_refresh_tap_label);
            this.mRefreshViewImage.setImageResource(R.drawable.button_pull_normal);
            this.mRefreshViewImage.clearAnimation();
            this.mRefreshViewImage.setVisibility(8);
            this.mRefreshViewProgress.setVisibility(8);
        }
    }

    private void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mCurrentScrollState == 1 && this.mRefreshState != 4) {
            if (firstVisibleItem == 0) {
                this.mRefreshViewImage.setVisibility(0);
                if ((this.mRefreshView.getBottom() >= this.mRefreshViewHeight + 20 || this.mRefreshView.getTop() >= 0) && this.mRefreshState != 3) {
                    this.mRefreshViewText.setText(R.string.pull_to_refresh_release_label);
                    this.mRefreshViewImage.clearAnimation();
                    this.mRefreshViewImage.startAnimation((Animation)this.mFlipAnimation);
                    this.mRefreshState = 3;
                } else if (this.mRefreshView.getBottom() < this.mRefreshViewHeight + 20 && this.mRefreshState != 2) {
                    this.mRefreshViewText.setText(R.string.pull_to_refresh_pull_label);
                    if (this.mRefreshState != 1) {
                        this.mRefreshViewImage.clearAnimation();
                        this.mRefreshViewImage.startAnimation((Animation)this.mReverseFlipAnimation);
                    }
                    this.mRefreshState = 2;
                }
            } else {
                this.mRefreshViewImage.setVisibility(8);
                this.resetHeader();
            }
        } else if (this.mCurrentScrollState == 2 && firstVisibleItem == 0 && this.mRefreshState != 4) {
            this.setSelection(1);
            this.mBounceHack = true;
        } else if (this.mBounceHack && this.mCurrentScrollState == 2) {
            this.setSelection(1);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mCurrentScrollState = scrollState;
        if (this.mCurrentScrollState == 0) {
            this.mBounceHack = false;
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void prepareForRefresh() {
        this.resetHeaderPadding();
        this.mRefreshViewImage.setVisibility(8);
        this.mRefreshViewImage.setImageDrawable(null);
        this.mRefreshViewProgress.setVisibility(0);
        this.mRefreshViewText.setText(R.string.pull_to_refresh_refreshing_label);
        this.mRefreshState = 4;
    }

    public void onRefresh() {
        Log.d((String)TAG, (String)"onRefresh");
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
    }

    public void onRefreshComplete(CharSequence lastUpdated) {
        this.setLastUpdated(lastUpdated);
        this.onRefreshComplete();
    }

    public void onRefreshComplete() {
        Log.d((String)TAG, (String)"onRefreshComplete");
        this.resetHeader();
        if (this.mRefreshView.getBottom() > 0) {
            this.invalidateViews();
            this.setSelection(1);
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }

    private class OnClickRefreshListener
    implements View.OnClickListener {
        private OnClickRefreshListener() {
        }

        public void onClick(View v) {
            if (PullToRefreshListView.this.mRefreshState != 4) {
                PullToRefreshListView.this.prepareForRefresh();
                PullToRefreshListView.this.onRefresh();
            }
        }
    }
}

