/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui;

import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;

public class SeekBarPreference
extends DialogPreference
implements SeekBar.OnSeekBarChangeListener {
    private static final String androidns = "http://schemas.android.com/apk/res/android";
    private SeekBar mSeekBar;
    private TextView mSplashText;
    private TextView mValueText;
    private Context mContext;
    private String mDialogMessage;
    private String mSuffix;
    private int mMax = 0;
    private int mValue = 0;
    private int mDefault = 0;
    private int mMin = 200;
    private static final String CLASS_TAG = SeekBarPreference.class.getCanonicalName();

    public SeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mDialogMessage = attrs.getAttributeValue(androidns, "dialogMessage");
        this.mSuffix = attrs.getAttributeValue(androidns, "text");
        this.mDefault = attrs.getAttributeIntValue(androidns, "defaultValue", this.mMin);
        this.mMax = attrs.getAttributeIntValue(androidns, "max", 100);
    }

    protected View onCreateDialogView() {
        LinearLayout layout2 = new LinearLayout(this.mContext);
        layout2.setOrientation(1);
        layout2.setPadding(6, 6, 6, 6);
        this.mSplashText = new TextView(this.mContext);
        if (this.mDialogMessage != null) {
            this.mSplashText.setText((CharSequence)this.mDialogMessage);
        }
        layout2.addView((View)this.mSplashText);
        this.mValueText = new TextView(this.mContext);
        this.mValueText.setGravity(1);
        this.mValueText.setTextSize(32.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        layout2.addView((View)this.mValueText, (ViewGroup.LayoutParams)params);
        this.mSeekBar = new SeekBar(this.mContext);
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        layout2.addView((View)this.mSeekBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        if (this.shouldPersist()) {
            this.mValue = this.getPersistedInt(this.mDefault);
        }
        this.mSeekBar.setMax(this.mMax);
        if (this.mValue < this.mMin) {
            this.mSeekBar.setProgress(this.mMin);
        } else {
            this.mSeekBar.setProgress(this.mValue);
        }
        return layout2;
    }

    protected void onBindDialogView(View v) {
        super.onBindDialogView(v);
        this.mSeekBar.setMax(this.mMax);
        this.mSeekBar.setProgress(this.mValue);
    }

    protected void onSetInitialValue(boolean restore, Object defaultValue) {
        super.onSetInitialValue(restore, defaultValue);
        this.mValue = restore ? (this.shouldPersist() ? this.getPersistedInt(this.mDefault) : this.mMin) : ((Integer)defaultValue > this.mMin ? (Integer)defaultValue : this.mMin);
    }

    public void onProgressChanged(SeekBar seek, int value, boolean fromTouch) {
        String t = "";
        t = value < this.mMin ? String.valueOf(this.mMin) : String.valueOf(value);
        Log.i((String)CLASS_TAG, (String)("SeekBar current value: " + value));
        this.mValueText.setText((CharSequence)(this.mSuffix == null ? t : t.concat(this.mSuffix)));
        if (this.shouldPersist()) {
            Log.i((String)CLASS_TAG, (String)("SeekBar is persisting " + value));
            this.persistInt(value);
        }
        this.callChangeListener(new Integer(value));
    }

    public void onStartTrackingTouch(SeekBar seek) {
    }

    public void onStopTrackingTouch(SeekBar seek) {
    }

    public void setMax(int max) {
        this.mMax = max;
    }

    public int getMax() {
        return this.mMax;
    }

    public void setProgress(int progress) {
        this.mValue = progress;
        if (this.mSeekBar != null) {
            this.mSeekBar.setProgress(progress);
        }
    }

    public int getProgress() {
        return this.mValue;
    }
}

