/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.view.MenuItem;
import android.text.TextUtils;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SpinnerAdapter;
import android.widget.ViewSwitcher;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseEditMapActivity;
import com.ushahidi.android.app.adapters.UploadPhotoAdapter;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.AddCheckinModel;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.services.UploadCheckins;
import com.ushahidi.android.app.util.PhotoUtils;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.AddCheckinView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AddCheckinActivity
extends BaseEditMapActivity<AddCheckinView, AddCheckinModel>
implements View.OnClickListener,
ViewSwitcher.ViewFactory,
AdapterView.OnItemClickListener {
    private boolean mError = false;
    private int id = 0;
    private UploadPhotoAdapter pendingPhoto;
    private String mErrorMessage;
    private final String PENDING_FOLDER = "pending/";
    private String photoName;
    private double latitude;
    private double longitude;
    private static final int DIALOG_ERROR_NETWORK = 0;
    private static final int DIALOG_ERROR_SAVING = 1;
    private static final int DIALOG_CHOOSE_IMAGE_METHOD = 2;
    private static final int DIALOG_SHOW_MESSAGE = 3;
    private static final int DIALOG_SHOW_REQUIRED = 4;
    private static final int DIALOG_SHOW_PROMPT = 5;
    private static final int DIALOG_SHOW_DELETE_PROMPT = 6;
    private static final int REQUEST_CODE_CAMERA = 0;
    private static final int REQUEST_CODE_IMAGE = 1;
    private AddCheckinModel model;
    private String locationName;
    private Intent uploadCheckins;
    private BroadcastReceiver uploadBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 3);
                AddCheckinActivity.this.stopService(AddCheckinActivity.this.uploadCheckins);
                try {
                    AddCheckinActivity.this.unregisterReceiver(AddCheckinActivity.this.uploadBroadcastReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ((AddCheckinView)((AddCheckinActivity)AddCheckinActivity.this).view).dialog.cancel();
                if (status == 0) {
                    AddCheckinActivity.this.toastLong(AddCheckinActivity.this.getString(R.string.uploaded));
                } else if (status == 1 || status == 2) {
                    AddCheckinActivity.this.toastLong(R.string.saved);
                }
            } else {
                AddCheckinActivity.this.toastLong(R.string.failed);
            }
            AddCheckinActivity.this.goToCheckin();
        }
    };

    public AddCheckinActivity() {
        super(AddCheckinView.class, R.layout.add_checkin, R.menu.add_checkin, R.id.checkin_location_map);
        this.model = new AddCheckinModel();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.id = this.getIntent().getExtras().getInt("id", 0);
        this.mapController = ((AddCheckinView)this.view).mMapView.getController();
        ((AddCheckinView)this.view).mPickPhoto.setOnClickListener((View.OnClickListener)this);
        this.pendingPhoto = new UploadPhotoAdapter((Context)this);
        ((AddCheckinView)this.view).gallery.setAdapter((SpinnerAdapter)this.pendingPhoto);
        ((AddCheckinView)this.view).gallery.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        ((AddCheckinView)this.view).mSwitcher.setFactory((ViewSwitcher.ViewFactory)this);
        if (this.id > 0) {
            ((AddCheckinView)this.view).mDeleteCheckin.setOnClickListener((View.OnClickListener)this);
            ((AddCheckinView)this.view).mDeleteCheckin.setVisibility(0);
            this.setSavedCheckins(this.id);
        } else {
            this.pendingPhoto.refresh();
        }
        this.registerForContextMenu((View)((AddCheckinView)this.view).gallery);
        this.hidePersonalInfo();
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu2, v, menuInfo);
        new MenuInflater((Context)this).inflate(R.menu.photo_context, (Menu)menu2);
    }

    public boolean onContextItemSelected(android.view.MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        boolean result = this.performAction(item, info.position);
        if (!result) {
            result = super.onContextItemSelected(item);
        }
        return result;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.uploadBroadcastReceiver, new IntentFilter(SyncServices.UPLOAD_CHECKIN_SERVICES_ACTION));
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.uploadBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean performAction(android.view.MenuItem item, int position) {
        if (item.getItemId() == R.id.remove_photo) {
            if (this.id == 0) {
                if (ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(position)).getPhoto())) {
                    this.pendingPhoto.refresh();
                }
                return true;
            }
            if (ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(position)).getPhoto())) {
                this.pendingPhoto.removeItem(position);
            }
            return true;
        }
        return false;
    }

    private void setSavedCheckins(int id2) {
        Checkin checkin = this.model.fetchPendingCheckinById(id2);
        if (checkin != null) {
            this.latitude = Double.valueOf(checkin.getLocationLatitude());
            this.longitude = Double.valueOf(checkin.getLocationLongitude());
            ((AddCheckinView)this.view).mCheckinMessageText.setText((CharSequence)checkin.getMessage());
            ((AddCheckinView)this.view).mCheckinLocation.setText((CharSequence)String.format("%f, %f", this.latitude, this.longitude));
            this.pendingPhoto.refresh(id2);
        }
    }

    private void validateCheckins() {
        this.mError = false;
        boolean required = false;
        if (TextUtils.isEmpty((CharSequence)((AddCheckinView)this.view).mCheckinMessageText.getText())) {
            this.mErrorMessage = this.getString(R.string.checkin_empty_message) + "\n";
            required = true;
        } else if (((AddCheckinView)this.view).mCheckinMessageText.getText().length() < 3 || ((AddCheckinView)this.view).mCheckinMessageText.getText().length() > 200) {
            this.mErrorMessage = this.getString(R.string.checkin_empty_message) + "\n";
            this.mError = true;
        }
        if (required) {
            this.showDialog(4);
        } else if (this.mError) {
            this.showDialog(3);
        } else {
            this.addCheckins();
        }
    }

    private void hidePersonalInfo() {
        if (!(TextUtils.isEmpty((CharSequence)Preferences.firstname) || TextUtils.isEmpty((CharSequence)Preferences.lastname) || TextUtils.isEmpty((CharSequence)Preferences.email))) {
            ((AddCheckinView)this.view).mContactLabel.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)Preferences.firstname)) {
            ((AddCheckinView)this.view).mFirstNameLabel.setVisibility(8);
            ((AddCheckinView)this.view).mFirstName.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)Preferences.lastname)) {
            ((AddCheckinView)this.view).mLastNameLabel.setVisibility(8);
            ((AddCheckinView)this.view).mLastName.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)Preferences.email)) {
            ((AddCheckinView)this.view).mEmaiLabel.setVisibility(8);
            ((AddCheckinView)this.view).mEmailAddress.setVisibility(8);
        }
        ((AddCheckinView)this.view).mFirstName.setText((CharSequence)Preferences.firstname);
        ((AddCheckinView)this.view).mLastName.setText((CharSequence)Preferences.lastname);
        ((AddCheckinView)this.view).mEmailAddress.setText((CharSequence)Preferences.email);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.showDialog();
            return true;
        }
        if (item.getItemId() == R.id.menu_send_checkin) {
            this.validateCheckins();
            return true;
        }
        if (item.getItemId() == R.id.menu_cancel_checkin) {
            this.showDialog(5);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 0) {
                Uri uri = PhotoUtils.getPhotoUri(this.photoName, (Activity)this);
                Bitmap bitmap = PhotoUtils.getCameraPhoto((Activity)this, uri);
                PhotoUtils.savePhoto((Activity)this, bitmap, this.photoName);
                this.log(String.format("REQUEST_CODE_CAMERA %dx%d", bitmap.getWidth(), bitmap.getHeight()));
            } else if (requestCode == 1) {
                Bitmap bitmap = PhotoUtils.getGalleryPhoto((Activity)this, data.getData());
                PhotoUtils.savePhoto((Activity)this, bitmap, this.photoName);
                this.log(String.format("REQUEST_CODE_IMAGE %dx%d", bitmap.getWidth(), bitmap.getHeight()));
            }
            if (this.id > 0) {
                this.addPhotoToCheckin();
            } else {
                this.pendingPhoto.refresh();
            }
        }
    }

    public void onClick(View button) {
        if (button.getId() == R.id.checkin_photo_button) {
            this.photoName = Util.getDateTime() + ".jpg";
            this.showDialog(2);
        } else if (button.getId() == R.id.delete_checkin) {
            this.showDialog(6);
        }
    }

    private void addPhotoToCheckin() {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            int id2 = 0;
            for (File file : pendingPhotos) {
                if (!file.exists()) continue;
                Photo photo = new Photo();
                photo.setDbId(++id2);
                photo.setPhoto("pending/" + file.getName());
                this.pendingPhoto.addItem(photo);
            }
        }
    }

    private void deleteExistingPhoto() {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            for (File file : pendingPhotos) {
                if (file == null || !file.exists()) continue;
                file.delete();
            }
        }
    }

    private void deleteCheckins() {
        if (this.id > 0 && this.model.deleteCheckin(this.id)) {
            for (int i = 0; i < this.pendingPhoto.getCount(); ++i) {
                ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(i)).getPhoto());
            }
            this.goToCheckin();
        }
    }

    private void addCheckins() {
        ((AddCheckinView)this.view).dialog.show();
        Checkin checkin = new Checkin();
        checkin.setPending(1);
        checkin.setMessage(((AddCheckinView)this.view).mCheckinMessageText.getText().toString());
        checkin.setLocationLatitude(String.valueOf(this.latitude));
        checkin.setLocationLongitude(String.valueOf(this.longitude));
        checkin.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        checkin.setLocationName(this.getString(R.string.unknown));
        Bundle checkins = new Bundle();
        checkins.putString("firstname", ((AddCheckinView)this.view).mFirstName.getText().toString());
        checkins.putString("lastname", ((AddCheckinView)this.view).mLastName.getText().toString());
        checkins.putString("email", ((AddCheckinView)this.view).mEmailAddress.getText().toString());
        checkins.putInt("pending", 1);
        checkins.putString("message", ((AddCheckinView)this.view).mCheckinMessageText.getText().toString());
        checkins.putString("latitude", String.valueOf(this.latitude));
        checkins.putString("longitude", String.valueOf(this.longitude));
        checkins.putString("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        checkins.putString("location", this.getString(R.string.unknown));
        checkins.putInt("id", this.id);
        this.uploadCheckins = new Intent((Context)this, UploadCheckins.class);
        this.uploadCheckins.putExtras(checkins);
        this.startService(this.uploadCheckins);
    }

    private void goToCheckin() {
        this.finish();
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 0: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.network_error));
                dialog.setMessage((CharSequence)this.getString(R.string.network_error_msg));
                dialog.setButton2((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 1: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.network_error));
                dialog.setMessage((CharSequence)this.getString(R.string.file_system_error_msg));
                dialog.setButton2((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 2: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.choose_method));
                dialog.setMessage((CharSequence)this.getString(R.string.how_to_select_pic));
                dialog.setButton((CharSequence)this.getString(R.string.gallery_option), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AddCheckinActivity.this.deleteExistingPhoto();
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.PICK");
                        intent.setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                        AddCheckinActivity.this.startActivityForResult(intent, 1);
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.cancel), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton3((CharSequence)this.getString(R.string.camera_option), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AddCheckinActivity.this.deleteExistingPhoto();
                        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                        intent.putExtra("output", (Parcelable)PhotoUtils.getPhotoUri(AddCheckinActivity.this.photoName, (Activity)AddCheckinActivity.this));
                        AddCheckinActivity.this.startActivityForResult(intent, 0);
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 3: {
                AlertDialog.Builder messageBuilder = new AlertDialog.Builder((Context)this);
                messageBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showDialog = messageBuilder.create();
                showDialog.show();
                break;
            }
            case 4: {
                AlertDialog.Builder requiredBuilder = new AlertDialog.Builder((Context)this);
                requiredBuilder.setTitle(R.string.required_fields);
                requiredBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showRequiredDialog = requiredBuilder.create();
                showRequiredDialog.show();
                break;
            }
            case 5: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.unsaved_changes));
                dialog.setMessage((CharSequence)this.getString(R.string.want_to_cancel));
                dialog.setButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        new BaseEditMapActivity.DiscardTask(AddCheckinActivity.this, (Activity)AddCheckinActivity.this).execute(new String[]{null});
                        AddCheckinActivity.this.finish();
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 6: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.delete_report));
                dialog.setMessage((CharSequence)this.getString(R.string.want_to_delete));
                dialog.setButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AddCheckinActivity.this.deleteCheckins();
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
        }
        return null;
    }

    @Override
    protected boolean onSaveChanges() {
        return true;
    }

    @Override
    protected boolean isRouteDisplayed() {
        return false;
    }

    @Override
    public void onLocationChanged(Location location) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected void locationChanged(double latitude, double longitude) {
        this.updateMarker(latitude, longitude, true);
        this.latitude = latitude;
        this.longitude = longitude;
        if (TextUtils.isEmpty((CharSequence)this.locationName)) {
            this.locationName = this.getString(R.string.unknown);
        }
        ((AddCheckinView)this.view).mCheckinLocation.setText((CharSequence)String.format("%f, %f", latitude, longitude));
    }

    public View makeView() {
        ImageView i = new ImageView((Context)this);
        i.setAdjustViewBounds(true);
        i.setScaleType(ImageView.ScaleType.FIT_XY);
        i.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        return i;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ((AddCheckinView)this.view).mSwitcher.setImageDrawable(ImageManager.getPendingDrawables((Context)this, ((Photo)this.pendingPhoto.getItem(position)).getPhoto(), Util.getScreenWidth((Context)this)));
    }

    @Override
    protected boolean onDiscardChanges() {
        this.deleteExistingPhoto();
        return true;
    }
}

