/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.text.TextUtils;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseEditActivity;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.services.UploadComments;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.AddCommentView;

public class AddCommentActivity
extends BaseEditActivity<AddCommentView, ListCommentModel> {
    private boolean mError = false;
    private String mErrorMessage;
    private Intent uploadComment;
    private int reportId;
    private int checkinId;
    private static final int DIALOG_SHOW_REQUIRED = 0;
    private static final int DIALOG_SHOW_MESSAGE = 1;
    private BroadcastReceiver uploadBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 3);
                AddCommentActivity.this.stopService(AddCommentActivity.this.uploadComment);
                try {
                    AddCommentActivity.this.unregisterReceiver(AddCommentActivity.this.uploadBroadcastReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                AddCommentActivity.this.stopService(AddCommentActivity.this.uploadComment);
                ((AddCommentView)((AddCommentActivity)AddCommentActivity.this).view).dialog.cancel();
                if (status == 0) {
                    AddCommentActivity.this.toastLong(AddCommentActivity.this.getString(R.string.uploaded));
                } else if (status == 1 || status == 2) {
                    AddCommentActivity.this.toastLong(R.string.saved);
                }
            } else {
                AddCommentActivity.this.toastLong(R.string.failed);
            }
            AddCommentActivity.this.finish();
        }
    };

    public AddCommentActivity() {
        super(AddCommentView.class, R.layout.add_comment, R.menu.add_comment);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.hidePersonalInfo();
        this.reportId = this.getIntent().getExtras().getInt("reportid", 0);
        this.checkinId = this.getIntent().getExtras().getInt("checkinid", 0);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.uploadBroadcastReceiver, new IntentFilter(SyncServices.UPLOAD_COMMENT_SERVICES_ACTION));
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.uploadBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_cancel_comment) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_send_comment) {
            this.validateComment();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void hidePersonalInfo() {
        if (!TextUtils.isEmpty((CharSequence)Preferences.lastname) || !TextUtils.isEmpty((CharSequence)Preferences.firstname)) {
            ((AddCommentView)this.view).fullNameLbl.setVisibility(8);
            ((AddCommentView)this.view).fullName.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)Preferences.email)) {
            ((AddCommentView)this.view).emailAddressLbl.setVisibility(8);
            ((AddCommentView)this.view).emailAddress.setVisibility(8);
        }
        ((AddCommentView)this.view).fullName.setText((CharSequence)String.format("%s %s ", Preferences.firstname, Preferences.lastname));
        ((AddCommentView)this.view).emailAddress.setText((CharSequence)Preferences.email);
    }

    private void validateComment() {
        this.mError = false;
        boolean required = false;
        if (TextUtils.isEmpty((CharSequence)((AddCommentView)this.view).fullName.getText().toString()) && (TextUtils.isEmpty((CharSequence)Preferences.firstname) || TextUtils.isEmpty((CharSequence)Preferences.lastname))) {
            this.mErrorMessage = this.getString(R.string.enter_full_name) + "\n";
            required = true;
        }
        if (TextUtils.isEmpty((CharSequence)((AddCommentView)this.view).emailAddress.getText().toString()) || !Util.validateEmail(((AddCommentView)this.view).emailAddress.getText().toString())) {
            this.mErrorMessage = this.getString(R.string.valid_email_address) + "\n";
            this.mError = true;
        }
        if (TextUtils.isEmpty((CharSequence)((AddCommentView)this.view).comment.getText().toString()) || ((AddCommentView)this.view).comment.getText().toString().length() < 3) {
            this.mErrorMessage = this.getString(R.string.enter_comment) + "\n";
            this.mError = true;
            required = true;
        }
        if (required) {
            this.showDialog(0);
        } else if (this.mError) {
            this.showDialog(1);
        } else {
            this.addComment();
        }
    }

    private void addComment() {
        ((AddCommentView)this.view).dialog.show();
        Bundle comments = new Bundle();
        comments.putString("comment_author", ((AddCommentView)this.view).fullName.getText().toString());
        comments.putString("comment_description", ((AddCommentView)this.view).comment.getText().toString());
        comments.putString("comment_email", ((AddCommentView)this.view).emailAddress.getText().toString());
        comments.putInt("report_id", this.reportId);
        comments.putInt("checkin_id", this.checkinId);
        this.uploadComment = new Intent((Context)this, UploadComments.class);
        this.uploadComment.putExtras(comments);
        this.startService(this.uploadComment);
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 1: {
                AlertDialog.Builder messageBuilder = new AlertDialog.Builder((Context)this);
                messageBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showDialog = messageBuilder.create();
                showDialog.show();
                break;
            }
            case 0: {
                AlertDialog.Builder requiredBuilder = new AlertDialog.Builder((Context)this);
                requiredBuilder.setTitle(R.string.required_fields);
                requiredBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showRequiredDialog = requiredBuilder.create();
                showRequiredDialog.show();
            }
        }
        return null;
    }

    @Override
    protected boolean onSaveChanges() {
        return false;
    }

    @Override
    protected boolean onDiscardChanges() {
        return true;
    }
}

