/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.view.MenuItem;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.DatePicker;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SpinnerAdapter;
import android.widget.TimePicker;
import android.widget.ViewSwitcher;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseEditMapActivity;
import com.ushahidi.android.app.adapters.UploadPhotoAdapter;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.database.OpenGeoSmsDao;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.entities.Report;
import com.ushahidi.android.app.entities.ReportCategory;
import com.ushahidi.android.app.models.AddReportModel;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.tasks.GeocoderTask;
import com.ushahidi.android.app.util.PhotoUtils;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.AddReportView;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class AddReportActivity
extends BaseEditMapActivity<AddReportView, AddReportModel>
implements View.OnClickListener,
ViewSwitcher.ViewFactory,
AdapterView.OnItemClickListener,
DialogInterface.OnClickListener {
    private ReverseGeocoderTask reverseGeocoderTask;
    private static final int DIALOG_ERROR_NETWORK = 0;
    private static final int DIALOG_ERROR_SAVING = 1;
    private static final int DIALOG_CHOOSE_IMAGE_METHOD = 2;
    private static final int DIALOG_MULTIPLE_CATEGORY = 3;
    private static final int TIME_DIALOG_ID = 4;
    private static final int DATE_DIALOG_ID = 5;
    private static final int DIALOG_SHOW_MESSAGE = 6;
    private static final int DIALOG_SHOW_REQUIRED = 7;
    private static final int DIALOG_SHOW_PROMPT = 8;
    private static final int DIALOG_SHOW_DELETE_PROMPT = 9;
    private static final int REQUEST_CODE_CAMERA = 0;
    private static final int REQUEST_CODE_IMAGE = 1;
    private Calendar mCalendar;
    private String mDateToSubmit = "";
    private int mCategoryLength;
    private Vector<String> mVectorCategories = new Vector();
    private Vector<String> mCategoriesId = new Vector();
    private HashMap<String, String> mCategoriesTitle = new HashMap();
    private boolean mError = false;
    private int id = 0;
    private UploadPhotoAdapter pendingPhoto;
    private String mErrorMessage;
    private String photoName;
    private AddReportModel model;
    private boolean mSendOpenGeoSms = false;
    private AlertDialog mDlgSendMethod;
    private OpenGeoSmsDao mOgsDao;
    private boolean mIsReportEditable = true;
    private DatePickerDialog.OnDateSetListener mDateSetListener = new DatePickerDialog.OnDateSetListener(){

        public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
            AddReportActivity.this.mCalendar.set(year, monthOfYear, dayOfMonth);
            AddReportActivity.this.updateDisplay();
        }
    };
    private TimePickerDialog.OnTimeSetListener mTimeSetListener = new TimePickerDialog.OnTimeSetListener(){

        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
            AddReportActivity.this.mCalendar.set(11, hourOfDay);
            AddReportActivity.this.mCalendar.set(12, minute);
            AddReportActivity.this.updateDisplay();
        }
    };
    private TextWatcher latLonTextWatcher = new TextWatcher(){

        public void afterTextChanged(Editable s) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            try {
                if (((AddReportView)((AddReportActivity)AddReportActivity.this).view).mLatitude.hasFocus() || ((AddReportView)((AddReportActivity)AddReportActivity.this).view).mLongitude.hasFocus()) {
                    AddReportActivity.this.locationChanged(Double.parseDouble(((AddReportView)((AddReportActivity)AddReportActivity.this).view).mLatitude.getText().toString()), Double.parseDouble(((AddReportView)((AddReportActivity)AddReportActivity.this).view).mLongitude.getText().toString()));
                }
            }
            catch (Exception ex) {
                AddReportActivity.this.log("TextWatcher", ex);
            }
        }
    };

    public AddReportActivity() {
        super(AddReportView.class, R.layout.add_report, R.menu.add_report, R.id.location_map);
        this.model = new AddReportModel();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((AddReportView)this.view).mLatitude.addTextChangedListener(this.latLonTextWatcher);
        ((AddReportView)this.view).mLongitude.addTextChangedListener(this.latLonTextWatcher);
        this.mapController = ((AddReportView)this.view).mapView.getController();
        ((AddReportView)this.view).mBtnPicture.setOnClickListener((View.OnClickListener)this);
        ((AddReportView)this.view).mBtnAddCategory.setOnClickListener((View.OnClickListener)this);
        ((AddReportView)this.view).mPickDate.setOnClickListener((View.OnClickListener)this);
        ((AddReportView)this.view).mPickTime.setOnClickListener((View.OnClickListener)this);
        this.mCalendar = Calendar.getInstance();
        this.pendingPhoto = new UploadPhotoAdapter((Context)this);
        ((AddReportView)this.view).gallery.setAdapter((SpinnerAdapter)this.pendingPhoto);
        ((AddReportView)this.view).gallery.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        ((AddReportView)this.view).mSwitcher.setFactory((ViewSwitcher.ViewFactory)this);
        if (this.getIntent().getExtras() != null) {
            this.id = this.getIntent().getExtras().getInt("id", 0);
        }
        this.mOgsDao = Database.mOpenGeoSmsDao;
        if (this.id > 0) {
            ((AddReportView)this.view).mDeleteReport.setOnClickListener((View.OnClickListener)this);
            ((AddReportView)this.view).mDeleteReport.setVisibility(0);
            this.setSavedReport(this.id);
        } else {
            this.updateDisplay();
            this.pendingPhoto.refresh();
        }
        this.registerForContextMenu((View)((AddReportView)this.view).gallery);
        this.createSendMethodDialog();
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (this.reverseGeocoderTask != null) {
            this.reverseGeocoderTask.cancel(true);
        }
    }

    @Override
    protected void onResume() {
        this.getSharedText();
        super.onResume();
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu2, v, menuInfo);
        new MenuInflater((Context)this).inflate(R.menu.photo_context, (Menu)menu2);
    }

    public boolean onContextItemSelected(android.view.MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        boolean result = this.performAction(item, info.position);
        if (!result) {
            result = super.onContextItemSelected(item);
        }
        return result;
    }

    public boolean performAction(android.view.MenuItem item, int position) {
        if (item.getItemId() == R.id.remove_photo) {
            if (this.id == 0) {
                if (ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(position)).getPhoto())) {
                    this.pendingPhoto.refresh();
                }
                return true;
            }
            if (ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(position)).getPhoto())) {
                this.pendingPhoto.removeItem(position);
            }
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.showDialog();
            return true;
        }
        if (item.getItemId() == R.id.menu_send) {
            this.validateReports();
            return true;
        }
        if (item.getItemId() == R.id.menu_clear) {
            this.showDialog(8);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onClick(View button) {
        if (button.getId() == R.id.btnPicture) {
            Preferences.fileName = this.photoName = Util.getDateTime() + ".jpg";
            Preferences.saveSettings((Context)this);
            this.showDialog(2);
        } else if (button.getId() == R.id.add_category) {
            this.showDialog(3);
        } else if (button.getId() == R.id.pick_date) {
            this.showDialog(5);
        } else if (button.getId() == R.id.pick_time) {
            this.showDialog(4);
        } else if (button.getId() == R.id.delete_report) {
            this.showDialog(9);
        }
    }

    private void validateReports() {
        if (!this.mIsReportEditable) {
            this.onClick((DialogInterface)this.mDlgSendMethod, 1);
            return;
        }
        this.mError = false;
        boolean required = false;
        this.mErrorMessage = "";
        if (TextUtils.isEmpty((CharSequence)((AddReportView)this.view).mIncidentTitle.getText())) {
            this.mErrorMessage = this.getString(R.string.title) + "\n";
            required = true;
        } else if (((AddReportView)this.view).mIncidentTitle.getText().length() < 3 || ((AddReportView)this.view).mIncidentTitle.getText().length() > 200) {
            this.mErrorMessage = this.getString(R.string.less_report_title) + "\n";
            this.mError = true;
        }
        if (TextUtils.isEmpty((CharSequence)((AddReportView)this.view).mIncidentDesc.getText())) {
            this.mErrorMessage = this.mErrorMessage + this.getString(R.string.description) + "\n";
            required = true;
        }
        if (this.mVectorCategories.size() == 0) {
            this.mErrorMessage = this.mErrorMessage + this.getString(R.string.category) + "\n";
            required = true;
        }
        if (TextUtils.isEmpty((CharSequence)((AddReportView)this.view).mLatitude.getText().toString())) {
            this.mErrorMessage = this.mErrorMessage + this.getString(R.string.latitude) + "\n";
            required = true;
        } else {
            try {
                Double.parseDouble(((AddReportView)this.view).mLatitude.getText().toString());
            }
            catch (NumberFormatException ex) {
                this.mErrorMessage = this.mErrorMessage + this.getString(R.string.invalid_latitude) + "\n";
                this.mError = true;
            }
        }
        if (TextUtils.isEmpty((CharSequence)((AddReportView)this.view).mLongitude.getText().toString())) {
            this.mErrorMessage = this.mErrorMessage + this.getString(R.string.longitude) + "\n";
            this.mError = true;
        } else {
            try {
                Double.parseDouble(((AddReportView)this.view).mLongitude.getText().toString());
            }
            catch (NumberFormatException ex) {
                this.mErrorMessage = this.mErrorMessage + this.getString(R.string.invalid_longitude) + "\n";
                this.mError = true;
            }
        }
        if (TextUtils.isEmpty((CharSequence)((AddReportView)this.view).mIncidentLocation.getText())) {
            this.mErrorMessage = this.mErrorMessage + this.getString(R.string.location);
            required = true;
        }
        if (required) {
            this.showDialog(7);
        } else if (this.mError) {
            this.showDialog(6);
        } else if (Preferences.canReceiveOpenGeoSms()) {
            this.mDlgSendMethod.show();
        } else {
            this.onClick((DialogInterface)this.mDlgSendMethod, 1);
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.mSendOpenGeoSms = which == 1;
        new BaseEditMapActivity.SaveTask(this, (Activity)this).execute(new String[]{null});
    }

    private void createSendMethodDialog() {
        Resources r = this.getResources();
        CharSequence[] items = new String[]{r.getString(R.string.internet), r.getString(R.string.opengeosms)};
        this.mDlgSendMethod = new AlertDialog.Builder((Context)this).setItems(items, (DialogInterface.OnClickListener)this).setTitle(R.string.send_report_dlg_title).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addReport() {
        this.log("Adding new reports");
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        Report report = new Report();
        report.setTitle(((AddReportView)this.view).mIncidentTitle.getText().toString());
        report.setDescription(((AddReportView)this.view).mIncidentDesc.getText().toString());
        report.setLatitude(((AddReportView)this.view).mLatitude.getText().toString());
        report.setLongitude(((AddReportView)this.view).mLongitude.getText().toString());
        report.setLocationName(((AddReportView)this.view).mIncidentLocation.getText().toString());
        report.setReportDate(this.mDateToSubmit);
        report.setMode(String.valueOf(0));
        report.setVerified(String.valueOf(0));
        report.setPending(1);
        if (this.id == 0) {
            if (!this.model.addPendingReport(report, this.mVectorCategories, pendingPhotos, ((AddReportView)this.view).mNews.getText().toString())) return false;
            this.log("Moving photos to fetched folder");
            ImageManager.movePendingPhotos((Context)this);
            this.id = report.getDbId();
        } else {
            ArrayList<Photo> photos = new ArrayList<Photo>();
            for (int i = 0; i < this.pendingPhoto.getCount(); ++i) {
                photos.add((Photo)this.pendingPhoto.getItem(i));
            }
            if (!this.model.updatePendingReport(this.id, report, this.mVectorCategories, photos, ((AddReportView)this.view).mNews.getText().toString())) return false;
            this.log("Moving photos to fetched folder");
            ImageManager.movePendingPhotos((Context)this);
        }
        if (this.mSendOpenGeoSms) {
            this.mOgsDao.addReport(this.id);
            return true;
        } else {
            this.mOgsDao.deleteReport(this.id);
        }
        return true;
    }

    private void setSavedReport(int reportId) {
        Report report = this.model.fetchPendingReportById(reportId);
        if (report != null) {
            ((AddReportView)this.view).mIncidentTitle.setText((CharSequence)report.getTitle());
            ((AddReportView)this.view).mIncidentDesc.setText((CharSequence)report.getDescription());
            ((AddReportView)this.view).mLongitude.setText((CharSequence)report.getLongitude());
            ((AddReportView)this.view).mLatitude.setText((CharSequence)report.getLatitude());
            ((AddReportView)this.view).mIncidentLocation.setText((CharSequence)report.getLocationName());
            this.setDateAndTime(report.getReportDate());
        }
        this.mVectorCategories.clear();
        for (ReportCategory reportCategory : this.model.fetchReportCategories(reportId)) {
            this.mVectorCategories.add(String.valueOf(reportCategory.getCategoryId()));
        }
        this.setSelectedCategories(this.mVectorCategories);
        this.pendingPhoto.refresh(this.id);
        List<Media> newsMedia = this.model.fetchReportNews(reportId);
        if (newsMedia != null && newsMedia.size() > 0) {
            ((AddReportView)this.view).mNews.setText((CharSequence)newsMedia.get(0).getLink());
        }
        boolean bl = this.mIsReportEditable = this.mOgsDao.getReportState(this.id) != 1;
        if (!this.mIsReportEditable) {
            View[] views;
            for (View v : views = new View[]{((AddReportView)this.view).mBtnAddCategory, ((AddReportView)this.view).mIncidentDesc, ((AddReportView)this.view).mIncidentLocation, ((AddReportView)this.view).mIncidentTitle, ((AddReportView)this.view).mLatitude, ((AddReportView)this.view).mLongitude, ((AddReportView)this.view).mPickDate, ((AddReportView)this.view).mPickTime}) {
                v.setEnabled(false);
            }
            this.updateMarker(Double.parseDouble(report.getLatitude()), Double.parseDouble(report.getLongitude()), true);
        }
    }

    private void deleteReport() {
        if (this.id > 0 && this.model.deleteReport(this.id)) {
            for (int i = 0; i < this.pendingPhoto.getCount(); ++i) {
                ImageManager.deletePendingPhoto((Context)this, "/" + ((Photo)this.pendingPhoto.getItem(i)).getPhoto());
            }
            this.finish();
        }
    }

    protected Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 0: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.network_error));
                dialog.setMessage((CharSequence)this.getString(R.string.network_error_msg));
                dialog.setButton2((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 1: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.network_error));
                dialog.setMessage((CharSequence)this.getString(R.string.file_system_error_msg));
                dialog.setButton2((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 2: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.choose_method));
                dialog.setMessage((CharSequence)this.getString(R.string.how_to_select_pic));
                dialog.setButton((CharSequence)this.getString(R.string.gallery_option), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent();
                        intent.setAction("android.intent.action.PICK");
                        intent.setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                        AddReportActivity.this.startActivityForResult(intent, 1);
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.cancel), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton3((CharSequence)this.getString(R.string.camera_option), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                        intent.putExtra("output", (Parcelable)PhotoUtils.getPhotoUri(AddReportActivity.this.photoName, (Activity)AddReportActivity.this));
                        AddReportActivity.this.startActivityForResult(intent, 0);
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 3: {
                if (this.showCategories() != null) {
                    return new AlertDialog.Builder((Context)this).setTitle(R.string.choose_categories).setMultiChoiceItems((CharSequence[])this.showCategories(), this.setCheckedCategories(), new DialogInterface.OnMultiChoiceClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton, boolean isChecked) {
                            if (isChecked) {
                                AddReportActivity.this.mVectorCategories.add(AddReportActivity.this.mCategoriesId.get(whichButton));
                                AddReportActivity.this.mError = false;
                            } else {
                                AddReportActivity.this.mVectorCategories.remove(AddReportActivity.this.mCategoriesId.get(whichButton));
                            }
                            AddReportActivity.this.setSelectedCategories(AddReportActivity.this.mVectorCategories);
                        }
                    }).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                        }
                    }).create();
                }
            }
            case 4: {
                return new TimePickerDialog((Context)this, this.mTimeSetListener, this.mCalendar.get(10), this.mCalendar.get(12), false);
            }
            case 5: {
                return new DatePickerDialog((Context)this, this.mDateSetListener, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
            }
            case 6: {
                AlertDialog.Builder messageBuilder = new AlertDialog.Builder((Context)this);
                messageBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showDialog = messageBuilder.create();
                showDialog.show();
                break;
            }
            case 7: {
                AlertDialog.Builder requiredBuilder = new AlertDialog.Builder((Context)this);
                requiredBuilder.setTitle(R.string.required_fields);
                requiredBuilder.setMessage((CharSequence)this.mErrorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showRequiredDialog = requiredBuilder.create();
                showRequiredDialog.show();
                break;
            }
            case 8: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.unsaved_changes));
                dialog.setMessage((CharSequence)this.getString(R.string.want_to_cancel));
                dialog.setButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        new BaseEditMapActivity.DiscardTask(AddReportActivity.this, (Activity)AddReportActivity.this).execute(new String[]{null});
                        AddReportActivity.this.finish();
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
            case 9: {
                AlertDialog dialog = new AlertDialog.Builder((Context)this).create();
                dialog.setTitle((CharSequence)this.getString(R.string.delete_report));
                dialog.setMessage((CharSequence)this.getString(R.string.want_to_delete));
                dialog.setButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setButton2((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AddReportActivity.this.deleteReport();
                        dialog.dismiss();
                    }
                });
                dialog.setCancelable(false);
                return dialog;
            }
        }
        return null;
    }

    protected void onPrepareDialog(int id2, Dialog dialog) {
        switch (id2) {
            case 4: {
                ((TimePickerDialog)dialog).updateTime(this.mCalendar.get(11), this.mCalendar.get(12));
                break;
            }
            case 5: {
                ((DatePickerDialog)dialog).updateDate(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
                break;
            }
            case 3: {
                AlertDialog alert = (AlertDialog)dialog;
                ListView list = alert.getListView();
                if (this.mVectorCategories.size() > 0) {
                    for (String s : this.mVectorCategories) {
                        try {
                            if (list == null) continue;
                            list.setItemChecked(this.mCategoryLength - Integer.parseInt(s), true);
                        }
                        catch (NumberFormatException e) {
                            this.log("NumberFormatException", e);
                        }
                    }
                    break;
                }
                if (list == null) break;
                list.clearChoices();
            }
        }
    }

    public String[] showCategories() {
        ListReportModel mListReportModel = new ListReportModel();
        List<Category> listCategories = mListReportModel.getAllCategories();
        if (listCategories != null && listCategories.size() > 0) {
            int categoryCount = listCategories.size();
            int categoryAmount = 0;
            if (categoryCount > 0) {
                categoryAmount = categoryCount;
            } else {
                this.mCategoriesId.clear();
                this.mCategoriesTitle.clear();
                categoryAmount = 1;
            }
            String[] categories = new String[categoryAmount];
            this.mCategoryLength = categories.length;
            int i = 0;
            for (Category category : mListReportModel.getAllCategories()) {
                categories[i] = category.getCategoryTitle();
                this.mCategoriesTitle.put(String.valueOf(category.getCategoryId()), category.getCategoryTitle());
                this.mCategoriesId.add(String.valueOf(category.getCategoryId()));
                ++i;
            }
            return categories;
        }
        return null;
    }

    private void updateDisplay() {
        Date date = this.mCalendar.getTime();
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM dd, yyyy");
            ((AddReportView)this.view).mPickDate.setText((CharSequence)dateFormat.format(date));
            SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
            ((AddReportView)this.view).mPickTime.setText((CharSequence)timeFormat.format(date));
            SimpleDateFormat submitFormat = new SimpleDateFormat("yyy-MM-dd kk:mm:ss", Locale.US);
            this.mDateToSubmit = submitFormat.format(date);
        } else {
            ((AddReportView)this.view).mPickDate.setText(R.string.change_date);
            ((AddReportView)this.view).mPickTime.setText(R.string.change_time);
            this.mDateToSubmit = null;
        }
    }

    private void setDateAndTime(String dateTime) {
        if (dateTime != null && !TextUtils.isEmpty((CharSequence)dateTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyy-MM-dd kk:mm:ss", Locale.US);
            try {
                Date date = dateFormat.parse(dateTime);
                if (date != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM dd, yyyy");
                    ((AddReportView)this.view).mPickDate.setText((CharSequence)simpleDateFormat.format(date));
                    SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
                    ((AddReportView)this.view).mPickTime.setText((CharSequence)timeFormat.format(date));
                    SimpleDateFormat submitFormat = new SimpleDateFormat("yyy-MM-dd kk:mm:ss", Locale.US);
                    this.mDateToSubmit = submitFormat.format(date);
                } else {
                    ((AddReportView)this.view).mPickDate.setText(R.string.change_date);
                    ((AddReportView)this.view).mPickTime.setText(R.string.change_time);
                    this.mDateToSubmit = null;
                }
            }
            catch (ParseException e) {
                this.log(e.getMessage());
            }
        }
    }

    private void setSelectedCategories(Vector<String> aSelectedCategories) {
        this.showCategories();
        ((AddReportView)this.view).mBtnAddCategory.setText(R.string.select_category);
        if (aSelectedCategories.size() > 0) {
            StringBuilder categories = new StringBuilder();
            for (String category : aSelectedCategories) {
                if (categories.length() > 0) {
                    categories.append(", ");
                }
                if (TextUtils.isEmpty((CharSequence)category)) continue;
                categories.append(this.mCategoriesTitle.get(category));
            }
            if (!TextUtils.isEmpty((CharSequence)categories.toString())) {
                ((AddReportView)this.view).mBtnAddCategory.setText((CharSequence)categories.toString());
            } else {
                ((AddReportView)this.view).mBtnAddCategory.setText(R.string.select_category);
            }
        }
    }

    private boolean[] setCheckedCategories() {
        ListReportModel mListReportModel;
        List<Category> listCategories;
        if (this.mVectorCategories != null && this.mVectorCategories.size() > 0 && (listCategories = (mListReportModel = new ListReportModel()).getAllCategories()) != null && listCategories.size() > 0) {
            int categoryCount = listCategories.size();
            int categoryAmount = 0;
            categoryAmount = categoryCount > 0 ? categoryCount : 1;
            boolean[] categories = new boolean[categoryAmount];
            this.mCategoryLength = categories.length;
            int i = 0;
            for (Category category : mListReportModel.getAllCategories()) {
                categories[i] = this.mVectorCategories.contains(String.valueOf(category.getCategoryId()));
                ++i;
            }
            return categories;
        }
        return null;
    }

    private void addPhotoToReport() {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            int id2 = 0;
            for (File file : pendingPhotos) {
                if (!file.exists()) continue;
                Photo photo = new Photo();
                photo.setDbId(++id2);
                photo.setPhoto("pending/" + file.getName());
                this.pendingPhoto.addItem(photo);
            }
        }
    }

    public void getSharedText() {
        CharSequence text;
        Intent intent = this.getIntent();
        String action = intent.getAction();
        if (action != null && (action.equals("android.intent.action.SEND") || action.equals("android.intent.action.CHOOSER")) && (text = intent.getCharSequenceExtra("android.intent.extra.TEXT")) != null) {
            ((AddReportView)this.view).mIncidentDesc.setText(text);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            Preferences.loadSettings((Context)this);
            this.photoName = Preferences.fileName;
            if (requestCode == 0) {
                Uri uri = PhotoUtils.getPhotoUri(this.photoName, (Activity)this);
                Bitmap bitmap = PhotoUtils.getCameraPhoto((Activity)this, uri);
                PhotoUtils.savePhoto((Activity)this, bitmap, this.photoName);
                this.log(String.format("REQUEST_CODE_CAMERA %dx%d", bitmap.getWidth(), bitmap.getHeight()));
            } else if (requestCode == 1) {
                Bitmap bitmap = PhotoUtils.getGalleryPhoto((Activity)this, data.getData());
                PhotoUtils.savePhoto((Activity)this, bitmap, this.photoName);
                this.log(String.format("REQUEST_CODE_IMAGE %dx%d", bitmap.getWidth(), bitmap.getHeight()));
            }
            if (this.id > 0) {
                this.addPhotoToReport();
            } else {
                this.pendingPhoto.refresh();
            }
        }
    }

    @Override
    protected void locationChanged(double latitude, double longitude) {
        if (!this.mIsReportEditable) {
            return;
        }
        this.updateMarker(latitude, longitude, true);
        if (!((AddReportView)this.view).mLatitude.hasFocus() && !((AddReportView)this.view).mLongitude.hasFocus()) {
            ((AddReportView)this.view).mLatitude.setText((CharSequence)String.valueOf(latitude));
            ((AddReportView)this.view).mLongitude.setText((CharSequence)String.valueOf(longitude));
        }
        if (this.reverseGeocoderTask == null || !this.reverseGeocoderTask.isExecuting()) {
            this.reverseGeocoderTask = new ReverseGeocoderTask((Context)this);
            this.reverseGeocoderTask.execute(new Double[]{latitude, longitude});
        }
    }

    public void goToReports() {
        this.finish();
    }

    @Override
    public void onLocationChanged(Location arg0) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected boolean onSaveChanges() {
        return this.addReport();
    }

    @Override
    protected boolean isRouteDisplayed() {
        return false;
    }

    public View makeView() {
        ImageView i = new ImageView((Context)this);
        i.setAdjustViewBounds(true);
        i.setScaleType(ImageView.ScaleType.FIT_CENTER);
        i.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        return i;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ((AddReportView)this.view).mSwitcher.setImageDrawable(ImageManager.getPendingDrawables((Context)this, ((Photo)this.pendingPhoto.getItem(position)).getPhoto(), Util.getScreenWidth((Context)this)));
    }

    private void deleteExistingPhoto() {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos((Context)this);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            for (File file : pendingPhotos) {
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    @Override
    protected boolean onDiscardChanges() {
        this.deleteExistingPhoto();
        return true;
    }

    private class ReverseGeocoderTask
    extends GeocoderTask {
        public ReverseGeocoderTask(Context context) {
            super(context);
        }

        @Override
        protected void onPostExecute(String result) {
            AddReportActivity.this.log(((Object)((Object)this)).getClass().getSimpleName(), new Object[]{String.format("onPostExecute %s", result)});
            if (TextUtils.isEmpty((CharSequence)((AddReportView)((AddReportActivity)AddReportActivity.this).view).mIncidentLocation.getText().toString())) {
                ((AddReportView)((AddReportActivity)AddReportActivity.this).view).mIncidentLocation.setText((CharSequence)result);
            }
            this.executing = false;
        }
    }
}

