/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseListActivity;
import com.ushahidi.android.app.adapters.CommentAdapter;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.services.FetchCheckinsComments;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AddCommentActivity;
import com.ushahidi.android.app.views.ListCommentView;

public class ListCheckinCommentActivity
extends BaseListActivity<ListCommentView, ListCommentModel, CommentAdapter> {
    private int checkinId = 0;
    private Intent fetchCheckinComments;
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                ((ListCommentView)((ListCheckinCommentActivity)ListCheckinCommentActivity.this).view).dialog.cancel();
                if (status == 4) {
                    ListCheckinCommentActivity.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    ListCheckinCommentActivity.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    ListCheckinCommentActivity.this.toastLong(R.string.could_not_fetch_comment);
                } else if (status == 0) {
                    ListCheckinCommentActivity.this.log("successfully fetched comments");
                }
            }
            try {
                ListCheckinCommentActivity.this.unregisterReceiver(ListCheckinCommentActivity.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ListCheckinCommentActivity.this.stopService(ListCheckinCommentActivity.this.fetchCheckinComments);
        }
    };

    public ListCheckinCommentActivity() {
        super(ListCommentView.class, CommentAdapter.class, R.layout.list_comment, R.menu.list_comment, 16908298);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.checkinId = this.getIntent().getExtras().getInt("checkinid");
        this.fetchComments();
        ((CommentAdapter)this.adapter).refreshCheckinComment(this.checkinId);
    }

    @Override
    public void onResume() {
        super.onResume();
        ((CommentAdapter)this.adapter).refreshCheckinComment(this.checkinId);
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void fetchComments() {
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_COMMENTS_SERVICES_ACTION));
        this.fetchCheckinComments = new Intent((Context)this, FetchCheckinsComments.class);
        this.fetchCheckinComments.putExtra("checkinid", this.checkinId);
        this.startService(this.fetchCheckinComments);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_comment) {
            this.goToAddComment(this.checkinId);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        this.checkinId = ((ListCommentModel)((CommentAdapter)this.adapter).getItem(position)).getCheckinId();
    }

    private void goToAddComment(int checkinId) {
        Intent i = new Intent((Context)this, AddCommentActivity.class);
        i.putExtra("checkinid", checkinId);
        this.startActivityForResult(i, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
    }

    @Override
    protected void onLoaded(boolean success) {
    }

    @Override
    protected View headerView() {
        return null;
    }
}

