/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.MenuItem;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.AdapterView;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.Settings;
import com.ushahidi.android.app.activities.BaseListActivity;
import com.ushahidi.android.app.adapters.ListMapAdapter;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.models.ListMapModel;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.net.CategoriesHttpClient;
import com.ushahidi.android.app.net.CheckinHttpClient;
import com.ushahidi.android.app.net.MapsHttpClient;
import com.ushahidi.android.app.net.ReportsHttpClient;
import com.ushahidi.android.app.services.FetchReports;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.ui.phone.AboutActivity;
import com.ushahidi.android.app.ui.phone.CheckinTabActivity;
import com.ushahidi.android.app.ui.phone.ReportTabActivity;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.views.AddMapView;
import com.ushahidi.android.app.views.ListMapView;
import java.util.Date;
import java.util.List;

public class ListMapActivity
extends BaseListActivity<ListMapView, ListMapModel, ListMapAdapter>
implements LocationListener {
    private final String[] items = new String[]{"50", "100", "250", "500", "750", "1000", "1500"};
    private static final int DIALOG_DISTANCE = 0;
    private static final int DIALOG_CLEAR_DEPLOYMENT = 1;
    private static final int DIALOG_ADD_DEPLOYMENT = 2;
    private static final int DIALOG_SHOW_MESSAGE = 3;
    private LocationManager mLocationMgr = null;
    private static Location location;
    private String distance = "";
    private Handler mHandler;
    private int mId = 0;
    private int mapId = 0;
    private ListMapModel listMapModel;
    private boolean edit = true;
    private String filter = null;
    private String errorMessage = "";
    private Intent fetchReports;
    public ProgressDialog dialog;
    final Runnable mDeleteMapById = new Runnable(){

        @Override
        public void run() {
            boolean status = false;
            status = ListMapActivity.this.listMapModel.deleteMapById(ListMapActivity.this.mId);
            try {
                if (status) {
                    ListMapActivity.this.toastShort(R.string.map_deleted);
                    ((ListMapAdapter)ListMapActivity.this.adapter).refresh();
                } else {
                    ListMapActivity.this.toastShort(R.string.map_deleted_failed);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ((ListMapAdapter)ListMapActivity.this.adapter).refresh();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable filterMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ((ListMapAdapter)ListMapActivity.this.adapter).getFilter().filter((CharSequence)ListMapActivity.this.filter);
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable deleteAllMaps = new Runnable(){

        @Override
        public void run() {
            boolean status = false;
            status = ListMapActivity.this.listMapModel.deleteAllMap((Context)ListMapActivity.this);
            try {
                if (status) {
                    ListMapActivity.this.toastShort(R.string.map_deleted);
                    ListMapActivity.this.refreshMapLists();
                } else {
                    ListMapActivity.this.toastShort(R.string.map_deleted_failed);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable refreshMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ListMapActivity.this.refreshMapLists();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 113);
                ListMapActivity.this.stopService(ListMapActivity.this.fetchReports);
                ListMapActivity.this.dialog.cancel();
                if (status == 0) {
                    ListMapActivity.this.onLoaded(true);
                } else if (status == 100) {
                    ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.internet_connection);
                    ListMapActivity.this.createDialog(3);
                } else if (status == 99) {
                    ListMapActivity.this.toastLong(R.string.no_reports);
                } else if (status == 112) {
                    ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.network_error);
                    ListMapActivity.this.createDialog(3);
                } else {
                    ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.error_occured);
                    ListMapActivity.this.createDialog(3);
                }
            } else {
                ListMapActivity.this.toastLong(R.string.failed);
            }
        }
    };

    public ListMapActivity() {
        super(ListMapView.class, ListMapAdapter.class, R.layout.list_map, R.menu.list_map, 16908298);
        this.mHandler = new Handler();
        this.listMapModel = new ListMapModel();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.actionBar.setDisplayHomeAsUpEnabled(false);
        this.registerForContextMenu((View)this.listView);
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setCancelable(true);
        this.dialog.setIndeterminate(true);
        this.dialog.setMessage((CharSequence)this.getString(R.string.please_wait));
        Preferences.loadSettings((Context)this);
        if (this.view != null) {
            ((ListMapView)this.view).mSearchMap.addTextChangedListener(new TextWatcher(){

                public void afterTextChanged(Editable arg0) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (!TextUtils.isEmpty((CharSequence)s.toString())) {
                        ListMapActivity.this.filter = s.toString();
                        ListMapActivity.this.mHandler.post(ListMapActivity.this.filterMapList);
                    } else {
                        ListMapActivity.this.mHandler.post(ListMapActivity.this.fetchMapList);
                    }
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.broadcastReceiver, new IntentFilter(SyncServices.SYNC_SERVICES_ACTION));
        this.mHandler.post(this.fetchMapList);
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.broadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.stopLocating();
    }

    public void refreshMapLists() {
        ((ListMapAdapter)this.adapter).refresh();
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        new MenuInflater((Context)this).inflate(R.menu.list_map_context, (Menu)menu2);
    }

    @Override
    public boolean onContextItemSelected(android.view.MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        boolean result = this.performAction(item, info.position);
        if (!result) {
            result = super.onContextItemSelected(item);
        }
        return result;
    }

    public boolean performAction(android.view.MenuItem item, int position) {
        this.mId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getId();
        this.mapId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getMapId();
        if (item.getItemId() == R.id.map_delete) {
            this.edit = false;
            this.mHandler.post(this.mDeleteMapById);
            return true;
        }
        if (item.getItemId() == R.id.map_edit) {
            this.edit = true;
            this.createDialog(2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear_map) {
            this.createDialog(1);
            return true;
        }
        if (item.getItemId() == R.id.menu_find) {
            this.createDialog(0);
            return true;
        }
        if (item.getItemId() == R.id.menu_add) {
            this.edit = false;
            this.createDialog(2);
            return true;
        }
        if (item.getItemId() == R.id.app_settings) {
            this.startActivity(new Intent((Context)this, Settings.class));
            this.setResult(-1);
            return true;
        }
        if (item.getItemId() == R.id.app_about) {
            this.startActivity(new Intent((Context)this, AboutActivity.class));
            this.setResult(-1);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        int sId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getId();
        if (this.isMapActive(sId)) {
            if (Preferences.isCheckinEnabled == 0) {
                this.goToReports();
            } else {
                this.goToCheckins();
            }
        } else {
            this.fetchReports(sId);
        }
    }

    private void fetchReports(int id2) {
        if (id2 != 0) {
            this.listMapModel.activateDeployment((Context)this, id2);
            this.dialog.show();
            this.fetchReports = new Intent((Context)this, FetchReports.class);
            this.startService(this.fetchReports);
        }
    }

    public boolean isMapActive(long id2) {
        Preferences.loadSettings((Context)this);
        return (long)Preferences.activeDeployment == id2;
    }

    private void goToReports() {
        Intent launchIntent = new Intent((Context)this, ReportTabActivity.class);
        this.startActivityForResult(launchIntent, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
    }

    private void goToCheckins() {
        Intent launchIntent = new Intent((Context)this, CheckinTabActivity.class);
        this.startActivityForResult(launchIntent, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
    }

    protected void createDialog(int d) {
        switch (d) {
            case 3: {
                AlertDialog.Builder messageBuilder = new AlertDialog.Builder((Context)this);
                messageBuilder.setMessage((CharSequence)this.errorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showDialog = messageBuilder.create();
                showDialog.show();
                break;
            }
            case 0: {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setTitle(R.string.select_distance);
                builder.setSingleChoiceItems((CharSequence[])this.items, Preferences.selectedDistance, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int item) {
                        ListMapActivity.this.distance = ListMapActivity.this.items[item];
                        ListMapActivity.this.setDeviceLocation();
                        Preferences.selectedDistance = item;
                        Preferences.saveSettings((Context)ListMapActivity.this);
                        dialog.cancel();
                        ListMapActivity.this.toastLong(R.string.finding_map);
                    }
                });
                AlertDialog alert = builder.create();
                alert.show();
                break;
            }
            case 1: {
                AlertDialog.Builder clearBuilder = new AlertDialog.Builder((Context)this);
                clearBuilder.setMessage((CharSequence)this.getString(R.string.confirm_clear)).setCancelable(false).setPositiveButton((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        ListMapActivity.this.mHandler.post(ListMapActivity.this.deleteAllMaps);
                    }
                }).setNegativeButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog clearDialog = clearBuilder.create();
                clearDialog.show();
                break;
            }
            case 2: {
                List<ListMapModel> listMap;
                LayoutInflater factory = LayoutInflater.from((Context)this);
                View textEntryView = factory.inflate(R.layout.add_map, null);
                final AddMapView addMapView = new AddMapView(textEntryView);
                if (this.edit && (listMap = this.listMapModel.loadMapById(this.mId, this.mapId)) != null && listMap.size() > 0) {
                    addMapView.setMapName(listMap.get(0).getName());
                    addMapView.setMapDescription(listMap.get(0).getDesc());
                    addMapView.setMapUrl(listMap.get(0).getUrl());
                    addMapView.setMapId(listMap.get(0).getId());
                }
                AlertDialog.Builder addBuilder = new AlertDialog.Builder((Context)this);
                addBuilder.setTitle(R.string.enter_map_details).setView(textEntryView).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.cancel();
                    }
                }).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (ListMapActivity.this.edit) {
                            if (!addMapView.updateMapDetails()) {
                                ListMapActivity.this.toastLong(R.string.fix_error);
                            } else {
                                ListMapActivity.this.mHandler.post(ListMapActivity.this.refreshMapList);
                            }
                        } else if (!addMapView.addMapDetails()) {
                            ListMapActivity.this.toastLong(R.string.fix_error);
                        } else {
                            ListMapActivity.this.mHandler.post(ListMapActivity.this.refreshMapList);
                        }
                    }
                });
                AlertDialog deploymentDialog = addBuilder.create();
                deploymentDialog.show();
            }
        }
    }

    public void clearCachedData() {
        new ListReportModel().deleteReport();
        new ListCheckinModel().deleteCheckin();
        new ListCommentModel().deleteComments();
        ImageManager.deleteImages((Context)this);
        ImageManager.deletePendingImages((Context)this);
    }

    @Override
    protected void onLoaded(boolean success) {
        try {
            if (success) {
                if (Preferences.isCheckinEnabled == 1) {
                    this.toastLong(R.string.checkin_is_enabled);
                    this.goToCheckins();
                } else {
                    this.goToReports();
                }
            } else {
                this.toastLong(R.string.failed);
            }
        }
        catch (IllegalArgumentException e) {
            this.log(e.toString());
        }
    }

    protected void setDeviceLocation() {
        boolean gpsAvail;
        this.mLocationMgr = (LocationManager)this.getSystemService("location");
        Location loc = null;
        boolean netAvail = this.mLocationMgr.getProvider("network") != null;
        boolean bl = gpsAvail = this.mLocationMgr.getProvider("gps") != null;
        if (gpsAvail) {
            loc = this.mLocationMgr.getLastKnownLocation("gps");
        } else if (netAvail) {
            loc = this.mLocationMgr.getLastKnownLocation("network");
        }
        if (loc != null && new Date().getTime() - loc.getTime() < 600000L) {
            this.onLocationChanged(loc);
        } else {
            if (gpsAvail) {
                this.mLocationMgr.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this);
            }
            if (netAvail) {
                this.mLocationMgr.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this);
            }
        }
    }

    public void stopLocating() {
        if (this.mLocationMgr != null) {
            try {
                this.mLocationMgr.removeUpdates((LocationListener)this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.mLocationMgr = null;
        }
    }

    public void onLocationChanged(Location loc) {
        if (loc != null) {
            location = loc;
            LoadMapTask deploymentTask = new LoadMapTask(this);
            deploymentTask.location = location;
            deploymentTask.distance = this.distance;
            deploymentTask.execute(new String[0]);
            this.stopLocating();
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected View headerView() {
        return null;
    }

    class FetchMapReportTask
    extends ProgressTask {
        protected int id;
        protected Integer status;

        public FetchMapReportTask(Activity activity) {
            super(activity, R.string.please_wait);
            this.status = 113;
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                if (this.id != 0) {
                    ListMapActivity.this.listMapModel.activateDeployment((Context)ListMapActivity.this, this.id);
                    ListMapActivity.this.clearCachedData();
                    if (!new ApiUtils((Context)ListMapActivity.this).isCheckinEnabled()) {
                        new CategoriesHttpClient((Context)ListMapActivity.this).getCategoriesFromWeb();
                        this.status = new ReportsHttpClient((Context)ListMapActivity.this).getAllReportFromWeb();
                        return false;
                    }
                    this.status = new CheckinHttpClient((Context)ListMapActivity.this).getAllCheckinFromWeb();
                    return true;
                }
                Thread.sleep(1000L);
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                if (this.status != null) {
                    if (this.status == 0) {
                        ListMapActivity.this.onLoaded(success);
                    } else if (this.status == 100) {
                        ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.internet_connection);
                        ListMapActivity.this.createDialog(3);
                    } else if (this.status == 99) {
                        ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.failed);
                        ListMapActivity.this.createDialog(3);
                    } else if (this.status == 112) {
                        ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.network_error);
                        ListMapActivity.this.createDialog(3);
                    } else {
                        ListMapActivity.this.errorMessage = ListMapActivity.this.getString(R.string.error_occured);
                        ListMapActivity.this.createDialog(3);
                    }
                } else {
                    ListMapActivity.this.toastLong(R.string.failed);
                }
            } else {
                ListMapActivity.this.toastLong(R.string.failed);
            }
        }
    }

    class LoadMapTask
    extends ProgressTask {
        protected Boolean status;
        protected Context appContext;
        private MapsHttpClient maps;
        protected String distance;
        protected Location location;

        public LoadMapTask(FragmentActivity activity) {
            super(activity, R.string.loading_);
            this.maps = new MapsHttpClient((Context)ListMapActivity.this);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog.cancel();
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                this.status = this.maps.fetchMaps(this.distance, this.location);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.status;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            if (!result.booleanValue()) {
                ListMapActivity.this.toastShort(R.string.could_not_fetch_data);
            } else {
                ListMapActivity.this.toastShort(R.string.maps_fetched_successful);
            }
            ((ListMapAdapter)ListMapActivity.this.adapter).refresh();
            ((ListMapView)((ListMapActivity)ListMapActivity.this).view).mProgressBar.setVisibility(8);
        }
    }
}

