/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseListActivity;
import com.ushahidi.android.app.adapters.CommentAdapter;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.services.FetchReportsComments;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AddCommentActivity;
import com.ushahidi.android.app.views.ListCommentView;

public class ListReportCommentActivity
extends BaseListActivity<ListCommentView, ListCommentModel, CommentAdapter> {
    private int reportId = 0;
    private Intent fetchReportComments;
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                ListReportCommentActivity.this.stopService(ListReportCommentActivity.this.fetchReportComments);
                ((ListCommentView)((ListReportCommentActivity)ListReportCommentActivity.this).view).dialog.cancel();
                if (status == 4) {
                    ListReportCommentActivity.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    ListReportCommentActivity.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    ListReportCommentActivity.this.toastLong(R.string.could_not_fetch_comment);
                } else if (status == 0) {
                    ListReportCommentActivity.this.log("successfully fetched comments");
                }
            }
            try {
                ListReportCommentActivity.this.unregisterReceiver(ListReportCommentActivity.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ListReportCommentActivity.this.stopService(ListReportCommentActivity.this.fetchReportComments);
        }
    };

    public ListReportCommentActivity() {
        super(ListCommentView.class, CommentAdapter.class, R.layout.list_comment, R.menu.list_comment, 16908298);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.reportId = this.getIntent().getExtras().getInt("reportid");
        this.fetchComments();
        ((CommentAdapter)this.adapter).refresh(this.reportId);
    }

    @Override
    public void onResume() {
        super.onResume();
        ((CommentAdapter)this.adapter).refresh(this.reportId);
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void fetchComments() {
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_REPORT_COMMENTS_SERVICES_ACTION));
        this.fetchReportComments = new Intent((Context)this, FetchReportsComments.class);
        this.fetchReportComments.putExtra("reportid", this.reportId);
        this.startService(this.fetchReportComments);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_comment) {
            this.goToAddComment(this.reportId);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        this.reportId = ((ListCommentModel)((CommentAdapter)this.adapter).getItem(position)).getReportId();
    }

    private void goToAddComment(int reportId) {
        Intent i = new Intent((Context)this, AddCommentActivity.class);
        i.putExtra("reportid", reportId);
        this.startActivityForResult(i, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
    }

    @Override
    protected void onLoaded(boolean success) {
    }

    @Override
    protected View headerView() {
        return null;
    }
}

