/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseMapViewActivity;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.models.ViewCheckinModel;
import com.ushahidi.android.app.services.FetchCheckinsComments;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AddCommentActivity;
import com.ushahidi.android.app.ui.phone.ListCheckinCommentActivity;
import com.ushahidi.android.app.ui.phone.ViewReportPhotoActivity;
import com.ushahidi.android.app.views.ViewCheckinView;
import java.util.List;

public class ViewCheckinActivity
extends BaseMapViewActivity<ViewCheckinView, ViewCheckinModel> {
    private ListCheckinModel checkinModel;
    private List<ListCheckinModel> listCheckin;
    private int position;
    private int userId;
    private int checkinId;
    private Intent fetchCheckinComments;
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                ViewCheckinActivity.this.stopService(ViewCheckinActivity.this.fetchCheckinComments);
                if (status == 4) {
                    ViewCheckinActivity.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    ViewCheckinActivity.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    ViewCheckinActivity.this.toastLong(R.string.could_not_fetch_comment);
                } else if (status == 0) {
                    ViewCheckinActivity.this.log("successfully fetched comments");
                    ((ViewCheckinView)ViewCheckinActivity.this.view).setListComments(ViewCheckinActivity.this.checkinId);
                }
            }
            try {
                ViewCheckinActivity.this.unregisterReceiver(ViewCheckinActivity.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };

    public ViewCheckinActivity() {
        super(ViewCheckinView.class, R.layout.view_checkin, R.menu.view_checkin, R.id.checkin_loc_map);
        this.checkinModel = new ListCheckinModel();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.userId = this.getIntent().getExtras().getInt("userid", 0);
        this.position = this.getIntent().getExtras().getInt("id", 0);
        if (this.userId > 0) {
            this.checkinModel.loadCheckinByUser(this.userId);
        } else {
            this.checkinModel.load();
        }
        this.initCheckin(this.position);
        this.fetchComments();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_forward) {
            if (this.listCheckin != null) {
                ++this.position;
                if (this.position <= this.listCheckin.size() - 1) {
                    this.initCheckin(this.position);
                    ((ViewCheckinView)this.view).goNext();
                } else {
                    this.position = this.listCheckin.size() - 1;
                }
            }
            return true;
        }
        if (item.getItemId() == R.id.menu_backward) {
            if (this.listCheckin != null) {
                --this.position;
                if (this.position < this.listCheckin.size() - 1 && this.position != -1) {
                    this.initCheckin(this.position);
                    ((ViewCheckinView)this.view).goPrevious();
                } else {
                    this.position = 0;
                }
            }
            return true;
        }
        if (item.getItemId() == R.id.menu_comment) {
            Intent i = new Intent((Context)this, AddCommentActivity.class);
            i.putExtra("checkinid", this.checkinId);
            this.startActivityForResult(i, 0);
            this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_COMMENTS_SERVICES_ACTION));
        ((ViewCheckinView)this.view).commentAdapter.refreshCheckinComment(this.checkinId);
        this.stopLocating();
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void fetchComments() {
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_COMMENTS_SERVICES_ACTION));
        this.fetchCheckinComments = new Intent((Context)this, FetchCheckinsComments.class);
        this.fetchCheckinComments.putExtra("checkinid", this.checkinId);
        this.startService(this.fetchCheckinComments);
    }

    private void initCheckin(int position) {
        this.listCheckin = this.checkinModel.getCheckins((Context)this);
        if (this.listCheckin != null) {
            this.checkinId = this.listCheckin.get(position).getCheckinId();
            if (this.view != null) {
                ((ViewCheckinView)this.view).setTitle(this.listCheckin.get(position).getUsername());
                ((ViewCheckinView)this.view).setBody(this.listCheckin.get(position).getMessage());
                ((ViewCheckinView)this.view).setDate(this.listCheckin.get(position).getDate());
                ((ViewCheckinView)this.view).setListPhotos(this.checkinId);
                ((ViewCheckinView)this.view).setListComments(this.checkinId);
                ((ViewCheckinView)this.view).getListPhotos().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent i = new Intent((Context)ViewCheckinActivity.this, ViewReportPhotoActivity.class);
                        i.putExtra("reportid", ViewCheckinActivity.this.checkinId);
                        i.putExtra("position", 0);
                        ViewCheckinActivity.this.startActivityForResult(i, 0);
                        ViewCheckinActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                    }
                });
                ((ViewCheckinView)this.view).setListComments(this.checkinId);
                ((ViewCheckinView)this.view).getListComments().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View v, int pos, long id2) {
                        Intent i = new Intent((Context)ViewCheckinActivity.this, ListCheckinCommentActivity.class);
                        i.putExtra("checkinid", ViewCheckinActivity.this.checkinId);
                        i.putExtra("position", pos);
                        ViewCheckinActivity.this.startActivityForResult(i, 0);
                        ViewCheckinActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                    }
                });
                this.centerLocationWithMarker(this.getPoint(Double.parseDouble(this.listCheckin.get(position).getLocationLatitude()), Double.parseDouble(this.listCheckin.get(position).getLocationLongitude())));
                ((ViewCheckinView)this.view).mapView.setBuiltInZoomControls(false);
                int page = position;
                this.setTitle(page + 1);
            }
        }
    }

    public void setTitle(int page) {
        StringBuilder title = new StringBuilder(String.valueOf(page));
        title.append("/");
        if (this.listCheckin != null) {
            title.append(this.listCheckin.size());
        }
        this.setActionBarTitle(title.toString());
    }

    @Override
    public void onLocationChanged(Location location) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected boolean isRouteDisplayed() {
        return false;
    }

    @Override
    protected void locationChanged(double latitude, double longitude) {
    }
}

