/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseMapViewActivity;
import com.ushahidi.android.app.adapters.ListFetchedReportAdapter;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.models.ViewReportModel;
import com.ushahidi.android.app.services.FetchReportsComments;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AddCommentActivity;
import com.ushahidi.android.app.ui.phone.ListReportCommentActivity;
import com.ushahidi.android.app.ui.phone.ViewReportNewsActivity;
import com.ushahidi.android.app.ui.phone.ViewReportPhotoActivity;
import com.ushahidi.android.app.ui.phone.ViewReportVideoActivity;
import com.ushahidi.android.app.views.ViewReportView;
import java.util.List;

public class ViewReportActivity
extends BaseMapViewActivity<ViewReportView, ViewReportModel> {
    private ListReportModel reports;
    private List<ListReportModel> report;
    private ListFetchedReportAdapter reportAdapter;
    private int position;
    private int categoryId;
    private int reportId;
    private String reportTitle;
    private Intent fetchReportComments;
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                ViewReportActivity.this.stopService(ViewReportActivity.this.fetchReportComments);
                ((ViewReportView)((ViewReportActivity)ViewReportActivity.this).view).dialog.cancel();
                if (status == 4) {
                    ViewReportActivity.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    ViewReportActivity.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    ViewReportActivity.this.toastLong(R.string.could_not_fetch_comment);
                } else if (status == 0) {
                    ViewReportActivity.this.log("successfully fetched comments");
                    ((ViewReportView)ViewReportActivity.this.view).setListComments(ViewReportActivity.this.reportId);
                }
            }
            try {
                ViewReportActivity.this.unregisterReceiver(ViewReportActivity.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };

    public ViewReportActivity() {
        super(ViewReportView.class, R.layout.view_report, R.menu.view_report, R.id.loc_map);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.reports = new ListReportModel();
        this.categoryId = this.getIntent().getExtras().getInt("category", 0);
        this.position = this.getIntent().getExtras().getInt("id", 0);
        if (this.categoryId > 0) {
            this.reports.loadReportByCategory(this.categoryId);
        } else {
            this.reports.load();
        }
        this.initReport(this.position);
        this.fetchComments();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_REPORT_COMMENTS_SERVICES_ACTION));
        this.stopLocating();
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void fetchComments() {
        this.registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_REPORT_COMMENTS_SERVICES_ACTION));
        this.fetchReportComments = new Intent((Context)this, FetchReportsComments.class);
        this.fetchReportComments.putExtra("reportid", this.reportId);
        this.startService(this.fetchReportComments);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_forward) {
            if (this.report != null) {
                ++this.position;
                if (this.position <= this.report.size() - 1) {
                    this.initReport(this.position);
                    ((ViewReportView)this.view).goNext();
                } else {
                    this.position = this.report.size() - 1;
                }
            }
            return true;
        }
        if (item.getItemId() == R.id.menu_backward) {
            if (this.report != null) {
                --this.position;
                if (this.position < this.report.size() - 1 && this.position != -1) {
                    this.initReport(this.position);
                    ((ViewReportView)this.view).goPrevious();
                } else {
                    this.position = 0;
                }
            }
            return true;
        }
        if (item.getItemId() == R.id.menu_share) {
            this.share();
        } else if (item.getItemId() == R.id.menu_comment) {
            Intent i = new Intent((Context)this, AddCommentActivity.class);
            i.putExtra("reportid", this.reportId);
            this.startActivityForResult(i, 0);
            this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        }
        return super.onOptionsItemSelected(item);
    }

    private String fetchCategories(int reportId) {
        this.reportAdapter = new ListFetchedReportAdapter((Context)this);
        return this.reportAdapter.fetchCategories(reportId);
    }

    private void initReport(int position) {
        this.report = this.reports.getReports((Context)this);
        if (this.report != null) {
            this.reportId = this.report.get(position).getReportId();
            this.reportTitle = this.report.get(position).getTitle();
            ((ViewReportView)this.view).setBody(this.report.get(position).getDesc());
            ((ViewReportView)this.view).setCategory(this.fetchCategories(this.reportId));
            ((ViewReportView)this.view).setLocation(this.report.get(position).getLocation());
            ((ViewReportView)this.view).setDate(this.report.get(position).getDate());
            ((ViewReportView)this.view).setTitle(this.report.get(position).getTitle());
            ((ViewReportView)this.view).setStatus(this.report.get(position).getStatus());
            ((ViewReportView)this.view).setListNews(this.reportId);
            ((ViewReportView)this.view).setListPhotos(this.reportId);
            ((ViewReportView)this.view).setListVideos(this.reportId);
            ((ViewReportView)this.view).setListComments(this.reportId);
            ((ViewReportView)this.view).getListPhotos().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent i = new Intent((Context)ViewReportActivity.this, ViewReportPhotoActivity.class);
                    i.putExtra("reportid", ViewReportActivity.this.reportId);
                    i.putExtra("position", 0);
                    ViewReportActivity.this.startActivityForResult(i, 0);
                    ViewReportActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                }
            });
            ((ViewReportView)this.view).getListNews().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    Intent i = new Intent((Context)ViewReportActivity.this, ViewReportNewsActivity.class);
                    i.putExtra("reportid", ViewReportActivity.this.reportId);
                    i.putExtra("position", position);
                    ViewReportActivity.this.startActivityForResult(i, 0);
                    ViewReportActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                }
            });
            ((ViewReportView)this.view).getListVideos().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    Intent i = new Intent((Context)ViewReportActivity.this, ViewReportVideoActivity.class);
                    i.putExtra("reportid", ViewReportActivity.this.reportId);
                    i.putExtra("position", position);
                    ViewReportActivity.this.startActivityForResult(i, 0);
                    ViewReportActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                }
            });
            ((ViewReportView)this.view).getListComments().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    Intent i = new Intent((Context)ViewReportActivity.this, ListReportCommentActivity.class);
                    i.putExtra("reportid", ViewReportActivity.this.reportId);
                    i.putExtra("position", position);
                    ViewReportActivity.this.startActivityForResult(i, 0);
                    ViewReportActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                }
            });
            this.centerLocationWithMarker(this.getPoint(Double.parseDouble(this.report.get(position).getLatitude()), Double.parseDouble(this.report.get(position).getLongitude())));
            ((ViewReportView)this.view).mapView.setBuiltInZoomControls(false);
            int page = position;
            this.setTitle(page + 1);
        }
    }

    public void setTitle(int page) {
        StringBuilder title = new StringBuilder(String.valueOf(page));
        title.append("/");
        if (this.report != null) {
            title.append(this.report.size());
        }
        this.setActionBarTitle(title.toString());
    }

    private void share() {
        String reportUrl = Preferences.domain + "reports/view/" + this.reportId;
        String shareString = this.getString(R.string.share_template, new Object[]{" " + this.reportTitle, "\n" + reportUrl});
        this.shareText(shareString);
    }

    @Override
    public void onLocationChanged(Location arg0) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected boolean isRouteDisplayed() {
        return false;
    }

    @Override
    protected void locationChanged(double latitude, double longitude) {
    }
}

